/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.camel.processor.idempotent.IdempotentOnCompletion;
import org.apache.camel.processor.idempotent.NoMessageIdException;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdempotentConsumer
extends ServiceSupport
implements AsyncProcessor,
Navigate<Processor> {
    private static final transient Logger LOG = LoggerFactory.getLogger(IdempotentConsumer.class);
    private final Expression messageIdExpression;
    private final AsyncProcessor processor;
    private final IdempotentRepository<String> idempotentRepository;
    private final boolean eager;

    public IdempotentConsumer(Expression messageIdExpression, IdempotentRepository<String> idempotentRepository, boolean eager, Processor processor) {
        this.messageIdExpression = messageIdExpression;
        this.idempotentRepository = idempotentRepository;
        this.eager = eager;
        this.processor = AsyncProcessorTypeConverter.convert(processor);
    }

    public String toString() {
        return "IdempotentConsumer[" + this.messageIdExpression + " -> " + this.processor + "]";
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        boolean newKey;
        String messageId = this.messageIdExpression.evaluate(exchange, String.class);
        if (messageId == null) {
            throw new NoMessageIdException(exchange, this.messageIdExpression);
        }
        if (this.eager) {
            newKey = this.idempotentRepository.add(messageId);
        } else {
            boolean bl = newKey = !this.idempotentRepository.contains(messageId);
        }
        if (!newKey) {
            this.onDuplicateMessage(exchange, messageId);
            callback.done(true);
            return true;
        }
        exchange.addOnCompletion(new IdempotentOnCompletion(this.idempotentRepository, messageId, this.eager));
        return this.processor.process(exchange, callback);
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add(this.processor);
        return answer;
    }

    @Override
    public boolean hasNext() {
        return this.processor != null;
    }

    public Expression getMessageIdExpression() {
        return this.messageIdExpression;
    }

    public IdempotentRepository<String> getIdempotentRepository() {
        return this.idempotentRepository;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.processor);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.processor);
    }

    protected void onDuplicateMessage(Exchange exchange, String messageId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ignoring duplicate message with id: " + messageId + " for exchange: " + exchange);
        }
    }
}

