/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.bean.BeanInvocation;
import org.apache.camel.component.bean.MethodInfo;
import org.apache.camel.component.bean.MethodInfoCache;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelInvocationHandler
implements InvocationHandler {
    private static final transient Logger LOG = LoggerFactory.getLogger(CamelInvocationHandler.class);
    private final Endpoint endpoint;
    private final Producer producer;
    private final MethodInfoCache methodInfoCache;

    public CamelInvocationHandler(Endpoint endpoint, Producer producer, MethodInfoCache methodInfoCache) {
        this.endpoint = endpoint;
        this.producer = producer;
        this.methodInfoCache = methodInfoCache;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        BeanInvocation invocation = new BeanInvocation(method, args);
        ExchangePattern pattern = ExchangePattern.InOut;
        MethodInfo methodInfo = this.methodInfoCache.getMethodInfo(method);
        if (methodInfo != null) {
            pattern = methodInfo.getPattern();
        }
        DefaultExchange exchange = new DefaultExchange(this.endpoint, pattern);
        exchange.getIn().setBody(invocation);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Proxied method call " + method.getName() + " invoking producer: " + this.producer);
        }
        this.producer.process(exchange);
        Exception cause = exchange.getException();
        if (cause != null) {
            Throwable found = this.findSuitableException(cause, method);
            if (found != null) {
                throw found;
            }
            if (cause instanceof RuntimeCamelException) {
                if (cause.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)((RuntimeCamelException)cause).getCause();
                }
                throw (RuntimeCamelException)cause;
            }
            throw cause;
        }
        Class<?> to = method.getReturnType();
        if (to == Void.TYPE || !pattern.isOutCapable()) {
            return null;
        }
        if (!exchange.hasOut() || exchange.getOut().getBody() == null) {
            return null;
        }
        Object answer = exchange.getOut().getMandatoryBody(to);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Proxied method call " + method.getName() + " returning: " + answer);
        }
        return answer;
    }

    protected Throwable findSuitableException(Throwable cause, Method method) {
        if (method.getExceptionTypes() == null || method.getExceptionTypes().length == 0) {
            return null;
        }
        for (Class<?> type : method.getExceptionTypes()) {
            Object fault = ObjectHelper.getException(type, cause);
            if (fault == null) continue;
            return (Throwable)Throwable.class.cast(fault);
        }
        return null;
    }
}

