/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.Service;
import org.apache.camel.ServiceStatus;
import org.apache.camel.ShutdownableService;
import org.apache.camel.util.ServiceHelper;

public abstract class ServiceSupport
implements Service,
ShutdownableService {
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean starting = new AtomicBoolean(false);
    private final AtomicBoolean stopping = new AtomicBoolean(false);
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final AtomicBoolean suspending = new AtomicBoolean(false);
    private final AtomicBoolean suspended = new AtomicBoolean(false);
    private final AtomicBoolean shuttingdown = new AtomicBoolean(false);
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private Set<Object> childServices;
    private String version;

    @Override
    public void start() throws Exception {
        this.start(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean startChildren) throws Exception {
        if (!this.started.get() && this.starting.compareAndSet(false, true)) {
            boolean childrenStarted = false;
            Exception ex = null;
            try {
                if (this.childServices != null && startChildren) {
                    ServiceHelper.startServices(this.childServices);
                }
                childrenStarted = true;
                this.doStart();
            }
            catch (Exception e) {
                ex = e;
            }
            finally {
                if (ex != null) {
                    try {
                        this.stop(childrenStarted);
                    }
                    catch (Exception e) {}
                    throw ex;
                }
                this.started.set(true);
                this.starting.set(false);
                this.stopping.set(false);
                this.stopped.set(false);
                this.suspending.set(false);
                this.suspended.set(false);
                this.shutdown.set(false);
                this.shuttingdown.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop(boolean childrenStarted) throws Exception {
        if (this.stopping.compareAndSet(false, true)) {
            try {
                try {
                    this.starting.set(false);
                    this.suspending.set(false);
                    if (childrenStarted) {
                        this.doStop();
                    }
                }
                finally {
                    this.started.set(false);
                    this.suspended.set(false);
                    if (this.childServices != null) {
                        ServiceHelper.stopServices(this.childServices);
                    }
                }
            }
            finally {
                this.stopped.set(true);
                this.stopping.set(false);
                this.starting.set(false);
                this.started.set(false);
                this.suspending.set(false);
                this.suspended.set(false);
                this.shutdown.set(false);
                this.shuttingdown.set(false);
            }
        }
    }

    @Override
    public void stop() throws Exception {
        if (!this.stopped.get()) {
            this.stop(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() throws Exception {
        if (!this.suspended.get() && this.suspending.compareAndSet(false, true)) {
            try {
                this.starting.set(false);
                this.stopping.set(false);
                this.doSuspend();
            }
            finally {
                this.stopped.set(false);
                this.stopping.set(false);
                this.starting.set(false);
                this.started.set(false);
                this.suspending.set(false);
                this.suspended.set(true);
                this.shutdown.set(false);
                this.shuttingdown.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws Exception {
        if (this.suspended.get() && this.starting.compareAndSet(false, true)) {
            try {
                this.doResume();
            }
            finally {
                this.started.set(true);
                this.starting.set(false);
                this.stopping.set(false);
                this.stopped.set(false);
                this.suspending.set(false);
                this.suspended.set(false);
                this.shutdown.set(false);
                this.shuttingdown.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() throws Exception {
        this.stop();
        if (this.shuttingdown.compareAndSet(false, true)) {
            try {
                try {
                    this.doShutdown();
                }
                finally {
                    if (this.childServices != null) {
                        ServiceHelper.stopAndShutdownService(this.childServices);
                    }
                }
            }
            finally {
                this.shutdown.set(true);
                this.shuttingdown.set(false);
            }
        }
    }

    public ServiceStatus getStatus() {
        if (this.isStarting()) {
            return ServiceStatus.Starting;
        }
        if (this.isStarted()) {
            return ServiceStatus.Started;
        }
        if (this.isStopping()) {
            return ServiceStatus.Stopping;
        }
        if (this.isStopped()) {
            return ServiceStatus.Stopped;
        }
        if (this.isSuspending()) {
            return ServiceStatus.Suspending;
        }
        if (this.isSuspended()) {
            return ServiceStatus.Suspended;
        }
        return ServiceStatus.Stopped;
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isStarting() {
        return this.starting.get();
    }

    public boolean isStopping() {
        return this.stopping.get();
    }

    public boolean isStopped() {
        return this.stopped.get();
    }

    public boolean isSuspending() {
        return this.suspending.get();
    }

    public boolean isSuspended() {
        return this.suspended.get();
    }

    public boolean isRunAllowed() {
        return !this.stopping.get() && !this.stopped.get();
    }

    protected abstract void doStart() throws Exception;

    protected abstract void doStop() throws Exception;

    protected void doSuspend() throws Exception {
    }

    protected void doResume() throws Exception {
    }

    protected void doShutdown() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildService(Object childService) {
        ServiceSupport serviceSupport = this;
        synchronized (serviceSupport) {
            if (this.childServices == null) {
                this.childServices = new LinkedHashSet<Object>();
            }
        }
        this.childServices.add(childService);
    }

    protected boolean removeChildService(Object childService) {
        return this.childServices != null && this.childServices.remove(childService);
    }

    public synchronized String getVersion() {
        Package aPackage;
        if (this.version != null) {
            return this.version;
        }
        try {
            Properties p = new Properties();
            InputStream is = this.getClass().getResourceAsStream("/META-INF/maven/org.apache.camel/camel-core/pom.properties");
            if (is != null) {
                p.load(is);
                this.version = p.getProperty("version", "");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.version == null && (aPackage = this.getClass().getPackage()) != null) {
            this.version = aPackage.getImplementationVersion();
            if (this.version == null) {
                this.version = aPackage.getSpecificationVersion();
            }
        }
        if (this.version == null) {
            this.version = "";
        }
        return this.version;
    }
}

