/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.Service;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;

public class LRUCache<K, V>
extends LinkedHashMap<K, V>
implements Service {
    private static final long serialVersionUID = -342098639681884413L;
    private int maxCacheSize = 10000;

    public LRUCache(int maximumCacheSize) {
        this(maximumCacheSize, maximumCacheSize, 0.75f, true);
    }

    public LRUCache(int initialCapacity, int maximumCacheSize, float loadFactor, boolean accessOrder) {
        super(initialCapacity, loadFactor, accessOrder);
        this.maxCacheSize = maximumCacheSize;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
        return this.size() > this.maxCacheSize;
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
        if (!this.isEmpty()) {
            ServiceHelper.stopServices(this.values());
            this.clear();
        }
    }

    @Override
    public String toString() {
        return "LRUCache@" + ObjectHelper.getIdentityHashCode(this);
    }
}

