/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.language.simple.SimpleLanguage;

public class SimpleBuilder
implements Predicate,
Expression {
    private final String text;
    private Class<?> resultType;

    public SimpleBuilder(String text) {
        this.text = text;
    }

    public static SimpleBuilder simple(String text) {
        return new SimpleBuilder(text);
    }

    public static SimpleBuilder simple(String text, Class<?> resultType) {
        SimpleBuilder answer = SimpleBuilder.simple(text);
        answer.setResultType(resultType);
        return answer;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    public SimpleBuilder resultType(Class<?> resultType) {
        this.setResultType(resultType);
        return this;
    }

    @Override
    public boolean matches(Exchange exchange) {
        return exchange.getContext().resolveLanguage("simple").createPredicate(this.text).matches(exchange);
    }

    @Override
    public <T> T evaluate(Exchange exchange, Class<T> type) {
        return this.createExpression(exchange).evaluate(exchange, type);
    }

    private Expression createExpression(Exchange exchange) {
        SimpleLanguage simple = (SimpleLanguage)exchange.getContext().resolveLanguage("simple");
        if (this.resultType != null) {
            simple.setResultType(this.resultType);
        }
        return simple.createExpression(this.text);
    }

    public String toString() {
        return "Simple: " + this.text;
    }
}

