/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.Exchange;
import org.apache.camel.ExpectedBodyTypeException;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeTransformException;
import org.apache.camel.builder.xml.DefaultTransformErrorHandler;
import org.apache.camel.builder.xml.DomResultHandlerFactory;
import org.apache.camel.builder.xml.FileResultHandlerFactory;
import org.apache.camel.builder.xml.ResultHandler;
import org.apache.camel.builder.xml.ResultHandlerFactory;
import org.apache.camel.builder.xml.StreamResultHandlerFactory;
import org.apache.camel.builder.xml.StringResultHandlerFactory;
import org.apache.camel.builder.xml.XsltUriResolver;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.impl.SynchronizationAdapter;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;

public class XsltBuilder
implements Processor {
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private XmlConverter converter = new XmlConverter();
    private Templates template;
    private ResultHandlerFactory resultHandlerFactory = new StringResultHandlerFactory();
    private boolean failOnNullBody = true;
    private URIResolver uriResolver;
    private boolean deleteOutputFile;

    public XsltBuilder() {
    }

    public XsltBuilder(Templates templates) {
        this.template = templates;
    }

    public String toString() {
        return "XSLT[" + this.template + "]";
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        ObjectHelper.notNull(this.getTemplate(), "template");
        if (this.isDeleteOutputFile()) {
            String fileName = ExchangeHelper.getMandatoryHeader(exchange, "CamelXsltFileName", String.class);
            exchange.addOnCompletion(new XsltBuilderOnCompletion(fileName));
        }
        Transformer transformer = this.getTemplate().newTransformer();
        this.configureTransformer(transformer, exchange);
        transformer.setErrorListener(new DefaultTransformErrorHandler());
        Source source = this.getSource(exchange);
        ResultHandler resultHandler = this.resultHandlerFactory.createResult(exchange);
        Result result = resultHandler.getResult();
        Message out = exchange.getOut();
        out.copyFrom(exchange.getIn());
        transformer.transform(source, result);
        resultHandler.setBody(out);
    }

    public static XsltBuilder xslt(Templates templates) {
        return new XsltBuilder(templates);
    }

    public static XsltBuilder xslt(Source xslt) throws TransformerConfigurationException {
        ObjectHelper.notNull(xslt, "xslt");
        XsltBuilder answer = new XsltBuilder();
        answer.setTransformerSource(xslt);
        return answer;
    }

    public static XsltBuilder xslt(File xslt) throws TransformerConfigurationException {
        ObjectHelper.notNull(xslt, "xslt");
        return XsltBuilder.xslt(new StreamSource(xslt));
    }

    public static XsltBuilder xslt(URL xslt) throws TransformerConfigurationException, IOException {
        ObjectHelper.notNull(xslt, "xslt");
        return XsltBuilder.xslt(xslt.openStream());
    }

    public static XsltBuilder xslt(InputStream xslt) throws TransformerConfigurationException, IOException {
        ObjectHelper.notNull(xslt, "xslt");
        return XsltBuilder.xslt(new StreamSource(xslt));
    }

    public XsltBuilder outputBytes() {
        this.setResultHandlerFactory(new StreamResultHandlerFactory());
        return this;
    }

    public XsltBuilder outputString() {
        this.setResultHandlerFactory(new StringResultHandlerFactory());
        return this;
    }

    public XsltBuilder outputDOM() {
        this.setResultHandlerFactory(new DomResultHandlerFactory());
        return this;
    }

    public XsltBuilder outputFile() {
        this.setResultHandlerFactory(new FileResultHandlerFactory());
        return this;
    }

    public XsltBuilder deleteOutputFile() {
        this.deleteOutputFile = true;
        return this;
    }

    public XsltBuilder parameter(String name, Object value) {
        this.parameters.put(name, value);
        return this;
    }

    public XsltBuilder uriResolver(URIResolver uriResolver) {
        this.setUriResolver(uriResolver);
        return this;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public void setTemplate(Templates template) {
        this.template = template;
    }

    public Templates getTemplate() {
        return this.template;
    }

    public boolean isFailOnNullBody() {
        return this.failOnNullBody;
    }

    public void setFailOnNullBody(boolean failOnNullBody) {
        this.failOnNullBody = failOnNullBody;
    }

    public ResultHandlerFactory getResultHandlerFactory() {
        return this.resultHandlerFactory;
    }

    public void setResultHandlerFactory(ResultHandlerFactory resultHandlerFactory) {
        this.resultHandlerFactory = resultHandlerFactory;
    }

    public void setTransformerSource(Source source) throws TransformerConfigurationException {
        Templates templates;
        TransformerFactory factory = this.converter.getTransformerFactory();
        if (this.getUriResolver() != null) {
            factory.setURIResolver(this.getUriResolver());
        }
        if ((templates = factory.newTemplates(source)) == null) {
            throw new TransformerConfigurationException("Error creating XSLT template. This is most likely be caused by a XML parse error. Please verify your XSLT file configured.");
        }
        this.setTemplate(templates);
    }

    public void setTransformerFile(File xslt) throws TransformerConfigurationException {
        this.setTransformerSource(new StreamSource(xslt));
    }

    public void setTransformerURL(URL url) throws TransformerConfigurationException, IOException {
        ObjectHelper.notNull(url, "url");
        this.setTransformerInputStream(url.openStream());
    }

    public void setTransformerInputStream(InputStream in) throws TransformerConfigurationException, IOException {
        ObjectHelper.notNull(in, "InputStream");
        this.setTransformerSource(new StreamSource(in));
    }

    public XmlConverter getConverter() {
        return this.converter;
    }

    public void setConverter(XmlConverter converter) {
        this.converter = converter;
    }

    public URIResolver getUriResolver() {
        return this.uriResolver;
    }

    public void setUriResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public boolean isDeleteOutputFile() {
        return this.deleteOutputFile;
    }

    public void setDeleteOutputFile(boolean deleteOutputFile) {
        this.deleteOutputFile = deleteOutputFile;
    }

    protected Source getSource(Exchange exchange) {
        Message in = exchange.getIn();
        Source source = in.getBody(Source.class);
        if (source == null) {
            if (this.isFailOnNullBody()) {
                throw new ExpectedBodyTypeException(exchange, Source.class);
            }
            try {
                source = this.converter.toDOMSource(this.converter.createDocument());
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeTransformException(e);
            }
        }
        return source;
    }

    protected void configureTransformer(Transformer transformer, Exchange exchange) {
        if (this.uriResolver == null) {
            this.uriResolver = new XsltUriResolver(exchange.getContext().getClassResolver(), null);
        }
        transformer.setURIResolver(this.uriResolver);
        transformer.clearParameters();
        this.addParameters(transformer, exchange.getProperties());
        this.addParameters(transformer, exchange.getIn().getHeaders());
        this.addParameters(transformer, this.getParameters());
        transformer.setParameter("exchange", exchange);
        transformer.setParameter("in", exchange.getIn());
        transformer.setParameter("out", exchange.getOut());
    }

    protected void addParameters(Transformer transformer, Map<String, Object> map) {
        Set<Map.Entry<String, Object>> propertyEntries = map.entrySet();
        for (Map.Entry<String, Object> entry : propertyEntries) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            transformer.setParameter(key, value);
        }
    }

    private final class XsltBuilderOnCompletion
    extends SynchronizationAdapter {
        private final String fileName;

        private XsltBuilderOnCompletion(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public void onDone(Exchange exchange) {
            FileUtil.deleteFile(new File(this.fileName));
        }

        public String toString() {
            return "XsltBuilderOnCompletion";
        }
    }
}

