/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.camel.AsyncCallback;
import org.apache.camel.BatchConsumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileConsumerSupport;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.camel.spi.ShutdownAware;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericFileConsumer<T>
extends ScheduledPollConsumer
implements BatchConsumer,
ShutdownAware {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    protected final ProcessFile processFile;
    protected GenericFileEndpoint<T> endpoint;
    protected GenericFileOperations<T> operations;
    protected String fileExpressionResult;
    protected int maxMessagesPerPoll;
    protected volatile ShutdownRunningTask shutdownRunningTask;
    protected volatile int pendingExchanges;

    public GenericFileConsumer(GenericFileEndpoint<T> endpoint, Processor processor, GenericFileOperations<T> operations) {
        super(endpoint, processor);
        this.endpoint = endpoint;
        this.operations = operations;
        this.processFile = new ProcessFile(this);
    }

    @Override
    public GenericFileEndpoint<T> getEndpoint() {
        return (GenericFileEndpoint)super.getEndpoint();
    }

    @Override
    protected int poll() throws Exception {
        int total;
        this.fileExpressionResult = null;
        this.shutdownRunningTask = null;
        this.pendingExchanges = 0;
        if (!this.prePollCheck()) {
            this.log.debug("Skipping poll as pre poll check returned false");
            return 0;
        }
        ArrayList<GenericFile<T>> files = new ArrayList<GenericFile<T>>();
        String name = ((GenericFileEndpoint)this.getEndpoint()).getConfiguration().getDirectory();
        StopWatch stop = new StopWatch();
        boolean limitHit = !this.pollDirectory(name, files);
        long delta = stop.stop();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Took {} to poll: {}", (Object)TimeUtils.printDuration(delta), (Object)name);
        }
        if (limitHit) {
            this.log.debug("Limiting maximum messages to poll at {} files as there was more messages in this poll.", (Object)this.maxMessagesPerPoll);
        }
        if (((GenericFileEndpoint)this.getEndpoint()).getSorter() != null) {
            Collections.sort(files, ((GenericFileEndpoint)this.getEndpoint()).getSorter());
        }
        LinkedList<Exchange> exchanges = new LinkedList<Exchange>();
        for (GenericFile genericFile : files) {
            Exchange exchange = ((GenericFileEndpoint)this.getEndpoint()).createExchange(genericFile);
            ((GenericFileEndpoint)this.getEndpoint()).configureExchange(exchange);
            ((GenericFileEndpoint)this.getEndpoint()).configureMessage(genericFile, exchange.getIn());
            exchanges.add(exchange);
        }
        if (((GenericFileEndpoint)this.getEndpoint()).getSortBy() != null) {
            Collections.sort(exchanges, ((GenericFileEndpoint)this.getEndpoint()).getSortBy());
        }
        if ((total = exchanges.size()) > 0) {
            this.log.debug("Total {} files to consume", (Object)total);
        }
        LinkedList<Exchange> linkedList = exchanges;
        int polledMessages = this.processBatch(CastUtils.cast(linkedList));
        this.postPollCheck();
        return polledMessages;
    }

    @Override
    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    @Override
    public int processBatch(Queue<Object> exchanges) {
        int total = exchanges.size();
        if (this.maxMessagesPerPoll > 0 && total > this.maxMessagesPerPoll) {
            this.log.debug("Limiting to maximum messages to poll {} as there was {} messages in this poll.", (Object)this.maxMessagesPerPoll, (Object)total);
            total = this.maxMessagesPerPoll;
        }
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = (Exchange)exchanges.poll();
            exchange.setProperty("CamelBatchIndex", index);
            exchange.setProperty("CamelBatchSize", total);
            exchange.setProperty("CamelBatchComplete", index == total - 1);
            this.pendingExchanges = total - index - 1;
            this.processExchange(exchange);
        }
        while (exchanges.size() > 0) {
            Exchange exchange = (Exchange)exchanges.poll();
            GenericFile file = (GenericFile)exchange.getProperty("CamelFileExchangeFile");
            String key = file.getAbsoluteFilePath();
            ((GenericFileEndpoint)this.getEndpoint()).getInProgressRepository().remove(key);
        }
        return total;
    }

    @Override
    public boolean deferShutdown(ShutdownRunningTask shutdownRunningTask) {
        this.shutdownRunningTask = shutdownRunningTask;
        return false;
    }

    @Override
    public int getPendingExchangesSize() {
        if (ShutdownRunningTask.CompleteAllTasks == this.shutdownRunningTask) {
            return this.pendingExchanges;
        }
        return 0;
    }

    @Override
    public void prepareShutdown() {
    }

    @Override
    public boolean isBatchAllowed() {
        boolean answer = this.isRunAllowed();
        if (!answer) {
            return false;
        }
        if (this.shutdownRunningTask == null) {
            return true;
        }
        return ShutdownRunningTask.CompleteAllTasks == this.shutdownRunningTask;
    }

    public boolean canPollMoreFiles(List fileList) {
        if (this.maxMessagesPerPoll <= 0) {
            return true;
        }
        return fileList.size() < this.maxMessagesPerPoll;
    }

    protected boolean prePollCheck() throws Exception {
        return true;
    }

    protected void postPollCheck() {
    }

    protected abstract boolean pollDirectory(String var1, List<GenericFile<T>> var2);

    public void setOperations(GenericFileOperations<T> operations) {
        this.operations = operations;
    }

    public GenericFileOperations<T> getOperations() {
        return this.operations;
    }

    protected void processExchange(Exchange exchange) {
        this.processFile.processExchange(exchange);
    }

    protected boolean isValidFile(GenericFile<T> file, boolean isDirectory) {
        if (!this.isMatched(file, isDirectory)) {
            this.log.trace("File did not match. Will skip this file: {}", file);
            return false;
        }
        if (((GenericFileEndpoint)this.getEndpoint()).isIdempotent().booleanValue() && ((GenericFileEndpoint)this.getEndpoint()).getIdempotentRepository().contains(file.getAbsoluteFilePath())) {
            this.log.trace("This consumer is idempotent and the file has been consumed before. Will skip this file: {}", file);
            return false;
        }
        return true;
    }

    protected boolean isMatched(GenericFile<T> file, boolean isDirectory) {
        String name = file.getFileNameOnly();
        if (name.startsWith(".")) {
            return false;
        }
        if (name.endsWith(".camelLock")) {
            return false;
        }
        if (isDirectory) {
            return true;
        }
        if (((GenericFileEndpoint)this.getEndpoint()).getFilter() != null && !((GenericFileEndpoint)this.getEndpoint()).getFilter().accept(file)) {
            return false;
        }
        if (ObjectHelper.isNotEmpty(((GenericFileEndpoint)this.getEndpoint()).getExclude()) && name.matches(((GenericFileEndpoint)this.getEndpoint()).getExclude())) {
            return false;
        }
        if (ObjectHelper.isNotEmpty(((GenericFileEndpoint)this.getEndpoint()).getInclude()) && !name.matches(((GenericFileEndpoint)this.getEndpoint()).getInclude())) {
            return false;
        }
        if (((GenericFileEndpoint)this.getEndpoint()).getFileName() != null) {
            this.evaluateFileExpression();
            if (this.fileExpressionResult != null && !name.equals(this.fileExpressionResult)) {
                return false;
            }
        }
        if (((GenericFileEndpoint)this.getEndpoint()).getDoneFileName() != null) {
            String doneFileName = ((GenericFileEndpoint)this.getEndpoint()).createDoneFileName(file.getAbsoluteFilePath());
            ObjectHelper.notEmpty(doneFileName, "doneFileName", this.getEndpoint());
            if (((GenericFileEndpoint)this.getEndpoint()).isDoneFile(file.getFileNameOnly())) {
                this.log.trace("Skipping done file: {}", file);
                return false;
            }
            if (!this.getOperations().existsFile(doneFileName)) {
                this.log.trace("Done file: {} does not exist", (Object)doneFileName);
                return false;
            }
        }
        return true;
    }

    protected boolean isInProgress(GenericFile<T> file) {
        String key = file.getAbsoluteFilePath();
        return !((GenericFileEndpoint)this.getEndpoint()).getInProgressRepository().add(key);
    }

    private void evaluateFileExpression() {
        if (this.fileExpressionResult == null) {
            DefaultExchange dummy = new DefaultExchange(((DefaultEndpoint)this.getEndpoint()).getCamelContext());
            this.fileExpressionResult = this.endpoint.getFileName().evaluate(dummy, String.class);
        }
    }

    private GenericFile<T> getExchangeFileProperty(Exchange exchange) {
        return (GenericFile)exchange.getProperty("CamelFileExchangeFile");
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        ((GenericFileEndpoint)this.getEndpoint()).getGenericFileProcessStrategy().prepareOnStartup(this.getOperations(), (GenericFileEndpoint<T>)this.getEndpoint());
    }

    private class ProcessFile
    extends GenericFileConsumerSupport<T> {
        public ProcessFile(GenericFileConsumer<T> consumer) {
            super(consumer);
        }

        @Override
        void handleExceptionStrategy(Exception e) {
            GenericFileConsumer.this.handleException(e);
        }

        @Override
        void processFileStrategy(Exchange exchange) {
            GenericFileConsumer.this.getAsyncProcessor().process(exchange, new AsyncCallback(){

                @Override
                public void done(boolean doneSync) {
                }
            });
        }
    }
}

