/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileConsumer;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOnCompletion;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericFileConsumerSupport<T> {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    protected final GenericFileConsumer<T> consumer;

    public GenericFileConsumerSupport(GenericFileConsumer<T> consumer) {
        this.consumer = consumer;
    }

    abstract void processFileStrategy(Exchange var1);

    abstract void handleExceptionStrategy(Exception var1);

    protected void processExchange(Exchange exchange) {
        GenericFile<T> file = this.getExchangeFileProperty(exchange);
        this.log.trace("Processing file: {}", file);
        String absoluteFileName = file.getAbsoluteFilePath();
        try {
            GenericFileProcessStrategy<T> processStrategy = ((GenericFileEndpoint)this.consumer.getEndpoint()).getGenericFileProcessStrategy();
            boolean begin = processStrategy.begin(this.consumer.getOperations(), (GenericFileEndpoint<T>)this.consumer.getEndpoint(), exchange, file);
            if (!begin) {
                this.log.debug(this.consumer.getEndpoint() + " cannot begin processing file: {}", file);
                ((GenericFileEndpoint)this.consumer.getEndpoint()).getInProgressRepository().remove(absoluteFileName);
                return;
            }
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.consumer.getEndpoint() + " cannot begin processing file: " + file + " due to: " + e.getMessage(), (Throwable)e);
            }
            ((GenericFileEndpoint)this.consumer.getEndpoint()).getInProgressRepository().remove(absoluteFileName);
            return;
        }
        GenericFile<T> target = this.getExchangeFileProperty(exchange);
        String name = target.getAbsoluteFilePath();
        try {
            this.log.trace("Retrieving file: {} from: {}", (Object)name, (Object)this.consumer.getEndpoint());
            boolean retrieved = this.consumer.getOperations().retrieveFile(name, exchange);
            if (!retrieved) {
                throw new GenericFileOperationFailedException("Cannot retrieve file: " + file + " from: " + this.consumer.getEndpoint());
            }
            this.log.trace("Retrieved file: {} from: {}", (Object)name, (Object)this.consumer.getEndpoint());
            exchange.addOnCompletion(new GenericFileOnCompletion<T>(this.consumer.getEndpoint(), this.consumer.getOperations(), target, absoluteFileName));
            this.log.debug("About to process file: {} using exchange: {}", target, (Object)exchange);
            this.processFileStrategy(exchange);
        }
        catch (Exception e) {
            ((GenericFileEndpoint)this.consumer.getEndpoint()).getInProgressRepository().remove(absoluteFileName);
            this.handleExceptionStrategy(e);
        }
    }

    private GenericFile<T> getExchangeFileProperty(Exchange exchange) {
        return (GenericFile)exchange.getProperty("CamelFileExchangeFile");
    }
}

