/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.WaitForTaskToComplete;
import org.apache.camel.component.seda.SedaConsumer;
import org.apache.camel.component.seda.SedaProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.spi.BrowsableEndpoint;
import org.apache.camel.util.ServiceHelper;

public class SedaEndpoint
extends DefaultEndpoint
implements BrowsableEndpoint,
MultipleConsumersSupport {
    private volatile BlockingQueue<Exchange> queue;
    private int size;
    private int concurrentConsumers = 1;
    private volatile ExecutorService multicastExecutor;
    private boolean multipleConsumers;
    private WaitForTaskToComplete waitForTaskToComplete = WaitForTaskToComplete.IfReplyExpected;
    private long timeout = 30000L;
    private volatile Set<SedaProducer> producers = new CopyOnWriteArraySet<SedaProducer>();
    private volatile Set<SedaConsumer> consumers = new CopyOnWriteArraySet<SedaConsumer>();
    private volatile MulticastProcessor consumerMulticastProcessor;
    private volatile boolean multicastStarted;

    public SedaEndpoint() {
    }

    public SedaEndpoint(String endpointUri, Component component, BlockingQueue<Exchange> queue) {
        this(endpointUri, component, queue, 1);
    }

    public SedaEndpoint(String endpointUri, Component component, BlockingQueue<Exchange> queue, int concurrentConsumers) {
        super(endpointUri, component);
        this.queue = queue;
        this.size = queue.remainingCapacity();
        this.concurrentConsumers = concurrentConsumers;
    }

    public SedaEndpoint(String endpointUri, BlockingQueue<Exchange> queue) {
        this(endpointUri, queue, 1);
    }

    public SedaEndpoint(String endpointUri, BlockingQueue<Exchange> queue, int concurrentConsumers) {
        super(endpointUri);
        this.queue = queue;
        this.size = queue.remainingCapacity();
        this.concurrentConsumers = concurrentConsumers;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new SedaProducer(this, this.getQueue(), this.getWaitForTaskToComplete(), this.getTimeout());
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        return new SedaConsumer(this, processor);
    }

    public synchronized BlockingQueue<Exchange> getQueue() {
        if (this.queue == null) {
            this.queue = this.size > 0 ? new LinkedBlockingQueue<Exchange>(this.size) : new LinkedBlockingQueue<Exchange>();
        }
        return this.queue;
    }

    protected synchronized MulticastProcessor getConsumerMulticastProcessor() throws Exception {
        if (!this.multicastStarted && this.consumerMulticastProcessor != null) {
            ServiceHelper.startService(this.consumerMulticastProcessor);
            this.multicastStarted = true;
        }
        return this.consumerMulticastProcessor;
    }

    protected synchronized void updateMulticastProcessor() throws Exception {
        int size;
        if (this.consumerMulticastProcessor != null) {
            ServiceHelper.stopService(this.consumerMulticastProcessor);
        }
        if ((size = this.getConsumers().size()) == 0 && this.multicastExecutor != null) {
            this.getCamelContext().getExecutorServiceStrategy().shutdown(this.multicastExecutor);
            this.multicastExecutor = null;
        }
        if (size > 1) {
            if (this.multicastExecutor == null) {
                this.multicastExecutor = this.getCamelContext().getExecutorServiceStrategy().newDefaultThreadPool(this, this.getEndpointUri() + "(multicast)");
            }
            ArrayList<Processor> processors = new ArrayList<Processor>(size);
            for (SedaConsumer consumer : this.getConsumers()) {
                processors.add(consumer.getProcessor());
            }
            this.multicastStarted = false;
            this.consumerMulticastProcessor = new MulticastProcessor(this.getCamelContext(), processors, null, true, this.multicastExecutor, false, false, 0L, null, false);
        } else {
            this.consumerMulticastProcessor = null;
        }
    }

    public void setQueue(BlockingQueue<Exchange> queue) {
        this.queue = queue;
        this.size = queue.remainingCapacity();
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public int getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    public WaitForTaskToComplete getWaitForTaskToComplete() {
        return this.waitForTaskToComplete;
    }

    public void setWaitForTaskToComplete(WaitForTaskToComplete waitForTaskToComplete) {
        this.waitForTaskToComplete = waitForTaskToComplete;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isMultipleConsumers() {
        return this.multipleConsumers;
    }

    public void setMultipleConsumers(boolean multipleConsumers) {
        this.multipleConsumers = multipleConsumers;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public List<Exchange> getExchanges() {
        return new ArrayList<Exchange>(this.getQueue());
    }

    @Override
    public boolean isMultipleConsumersSupported() {
        return this.isMultipleConsumers();
    }

    public Set<SedaConsumer> getConsumers() {
        return new HashSet<SedaConsumer>(this.consumers);
    }

    public Set<SedaProducer> getProducers() {
        return new HashSet<SedaProducer>(this.producers);
    }

    void onStarted(SedaProducer producer) {
        this.producers.add(producer);
    }

    void onStopped(SedaProducer producer) {
        this.producers.remove(producer);
    }

    void onStarted(SedaConsumer consumer) throws Exception {
        this.consumers.add(consumer);
        if (this.isMultipleConsumers()) {
            this.updateMulticastProcessor();
        }
    }

    void onStopped(SedaConsumer consumer) throws Exception {
        this.consumers.remove(consumer);
        if (this.isMultipleConsumers()) {
            this.updateMulticastProcessor();
        }
    }
}

