/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.AsyncProducerCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ProducerCallback;
import org.apache.camel.ServicePoolAware;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.camel.processor.UnitOfWorkProducer;
import org.apache.camel.spi.ServicePool;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.EventHelper;
import org.apache.camel.util.LRUCache;
import org.apache.camel.util.LRUSoftCache;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerCache
extends ServiceSupport {
    private static final transient Logger LOG = LoggerFactory.getLogger(ProducerCache.class);
    private final CamelContext camelContext;
    private final ServicePool<Endpoint, Producer> pool;
    private final Map<String, Producer> producers;
    private final Object source;

    public ProducerCache(Object source, CamelContext camelContext) {
        this(source, camelContext, CamelContextHelper.getMaximumCachePoolSize(camelContext));
    }

    public ProducerCache(Object source, CamelContext camelContext, int cacheSize) {
        this(source, camelContext, camelContext.getProducerServicePool(), ProducerCache.createLRUCache(cacheSize));
    }

    public ProducerCache(Object source, CamelContext camelContext, ServicePool<Endpoint, Producer> producerServicePool, Map<String, Producer> cache) {
        this.source = source;
        this.camelContext = camelContext;
        this.pool = producerServicePool;
        this.producers = cache;
    }

    protected static LRUCache<String, Producer> createLRUCache(int cacheSize) {
        return new LRUSoftCache<String, Producer>(cacheSize);
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Object getSource() {
        return this.source;
    }

    public Producer acquireProducer(Endpoint endpoint) {
        return this.doGetProducer(endpoint, true);
    }

    public void releaseProducer(Endpoint endpoint, Producer producer) throws Exception {
        if (producer instanceof ServicePoolAware) {
            this.pool.release(endpoint, producer);
        } else if (!producer.isSingleton()) {
            producer.stop();
        }
    }

    public void startProducer(Endpoint endpoint) throws Exception {
        Producer producer = this.acquireProducer(endpoint);
        this.releaseProducer(endpoint, producer);
    }

    public void send(Endpoint endpoint, Exchange exchange) {
        this.sendExchange(endpoint, null, null, exchange);
    }

    public Exchange send(Endpoint endpoint, Processor processor) {
        return this.sendExchange(endpoint, null, processor, null);
    }

    public Exchange send(Endpoint endpoint, ExchangePattern pattern, Processor processor) {
        return this.sendExchange(endpoint, pattern, processor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T doInProducer(Endpoint endpoint, Exchange exchange, ExchangePattern pattern, ProducerCallback<T> callback) {
        T answer = null;
        Producer producer = this.doGetProducer(endpoint, true);
        if (producer == null) {
            if (this.isStopped()) {
                LOG.warn("Ignoring exchange sent after processor is stopped: " + exchange);
                return null;
            }
            throw new IllegalStateException("No producer, this processor has not been started: " + this);
        }
        StopWatch watch = null;
        if (exchange != null) {
            watch = new StopWatch();
        }
        try {
            answer = callback.doInProducer(producer, exchange, pattern);
        }
        catch (Throwable e) {
            if (exchange != null) {
                exchange.setException(e);
            }
        }
        finally {
            if (exchange != null) {
                long timeTaken = watch.stop();
                EventHelper.notifyExchangeSent(exchange.getContext(), exchange, endpoint, timeTaken);
            }
            if (producer instanceof ServicePoolAware) {
                this.pool.release(endpoint, producer);
            } else if (!producer.isSingleton()) {
                try {
                    ServiceHelper.stopService(producer);
                }
                catch (Exception e) {
                    LOG.warn("Error stopping producer: " + producer, (Throwable)e);
                }
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doInAsyncProducer(Endpoint endpoint, Exchange exchange, ExchangePattern pattern, AsyncCallback callback, AsyncProducerCallback producerCallback) {
        boolean sync = true;
        Producer producer = this.doGetProducer(endpoint, true);
        if (producer == null) {
            if (this.isStopped()) {
                LOG.warn("Ignoring exchange sent after processor is stopped: " + exchange);
                return false;
            }
            throw new IllegalStateException("No producer, this processor has not been started: " + this);
        }
        StopWatch watch = null;
        if (exchange != null) {
            watch = new StopWatch();
        }
        try {
            AsyncProcessor asyncProcessor = AsyncProcessorTypeConverter.convert(producer);
            sync = producerCallback.doInAsyncProducer(producer, asyncProcessor, exchange, pattern, callback);
        }
        catch (Throwable e) {
            if (exchange != null) {
                exchange.setException(e);
            }
        }
        finally {
            if (exchange != null && exchange.getException() == null) {
                long timeTaken = watch.stop();
                EventHelper.notifyExchangeSent(exchange.getContext(), exchange, endpoint, timeTaken);
            }
            if (producer instanceof ServicePoolAware) {
                this.pool.release(endpoint, producer);
            } else if (!producer.isSingleton()) {
                try {
                    ServiceHelper.stopService(producer);
                }
                catch (Exception e) {
                    LOG.warn("Error stopping producer: " + producer, (Throwable)e);
                }
            }
        }
        return sync;
    }

    protected Exchange sendExchange(final Endpoint endpoint, ExchangePattern pattern, final Processor processor, Exchange exchange) {
        return this.doInProducer(endpoint, exchange, pattern, new ProducerCallback<Exchange>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Exchange doInProducer(Producer producer, Exchange exchange, ExchangePattern pattern) {
                if (exchange == null) {
                    Exchange exchange2 = exchange = pattern != null ? producer.createExchange(pattern) : producer.createExchange();
                }
                if (processor != null) {
                    try {
                        processor.process(exchange);
                    }
                    catch (Exception e) {
                        exchange.setException(e);
                        return exchange;
                    }
                }
                LOG.debug(">>>> {} {}", (Object)endpoint, (Object)exchange);
                exchange.setProperty("CamelToEndpoint", endpoint.getEndpointUri());
                StopWatch watch = new StopWatch();
                try {
                    UnitOfWorkProducer target = new UnitOfWorkProducer(producer);
                    target.process(exchange);
                }
                catch (Throwable e) {
                    exchange.setException(e);
                }
                finally {
                    long timeTaken = watch.stop();
                    EventHelper.notifyExchangeSent(exchange.getContext(), exchange, endpoint, timeTaken);
                }
                return exchange;
            }
        });
    }

    protected synchronized Producer doGetProducer(Endpoint endpoint, boolean pooled) {
        String key = endpoint.getEndpointUri();
        Producer answer = this.producers.get(key);
        if (pooled && answer == null) {
            answer = this.pool.acquire(endpoint);
        }
        if (answer == null) {
            try {
                answer = endpoint.createProducer();
                ServiceHelper.startService(answer);
            }
            catch (Exception e) {
                throw new FailedToCreateProducerException(endpoint, (Throwable)e);
            }
            if (pooled && answer instanceof ServicePoolAware) {
                LOG.debug("Adding to producer service pool with key: {} for producer: {}", (Object)endpoint, (Object)answer);
                answer = this.pool.addAndAcquire(endpoint, answer);
            } else if (answer.isSingleton()) {
                LOG.debug("Adding to producer cache with key: {} for producer: {}", (Object)endpoint, (Object)answer);
                this.producers.put(key, answer);
            }
        }
        return answer;
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.producers, this.pool);
        this.producers.clear();
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.pool, this.producers);
    }

    public int size() {
        int size = this.producers.size();
        LOG.trace("size = {}", (Object)(size += this.pool.size()));
        return size;
    }

    public int getCapacity() {
        int capacity = -1;
        if (this.producers instanceof LRUCache) {
            LRUCache cache = (LRUCache)this.producers;
            capacity = cache.getMaxCacheSize();
        }
        return capacity;
    }

    public long getHits() {
        long hits = -1L;
        if (this.producers instanceof LRUCache) {
            LRUCache cache = (LRUCache)this.producers;
            hits = cache.getHits();
        }
        return hits;
    }

    public long getMisses() {
        long misses = -1L;
        if (this.producers instanceof LRUCache) {
            LRUCache cache = (LRUCache)this.producers;
            misses = cache.getMisses();
        }
        return misses;
    }

    public void resetCacheStatistics() {
        if (this.producers instanceof LRUCache) {
            LRUCache cache = (LRUCache)this.producers;
            cache.resetStatistics();
        }
    }

    public synchronized void purge() {
        this.producers.clear();
        this.pool.purge();
    }

    public String toString() {
        return "ProducerCache for source: " + this.source + ", capacity: " + this.getCapacity();
    }
}

