/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.osgi;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Converter;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.impl.converter.AnnotationTypeConverterLoader;
import org.apache.camel.impl.osgi.tracker.BundleTracker;
import org.apache.camel.impl.osgi.tracker.BundleTrackerCustomizer;
import org.apache.camel.impl.scan.AnnotatedWithPackageScanFilter;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatResolver;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator,
BundleTrackerCustomizer {
    public static final String META_INF_COMPONENT = "META-INF/services/org/apache/camel/component/";
    public static final String META_INF_LANGUAGE = "META-INF/services/org/apache/camel/language/";
    public static final String META_INF_LANGUAGE_RESOLVER = "META-INF/services/org/apache/camel/language/resolver/";
    public static final String META_INF_DATAFORMAT = "META-INF/services/org/apache/camel/dataformat/";
    public static final String META_INF_TYPE_CONVERTER = "META-INF/services/org/apache/camel/TypeConverter";
    public static final String META_INF_FALLBACK_TYPE_CONVERTER = "META-INF/services/org/apache/camel/FallbackTypeConverter";
    private static final transient Logger LOG = LoggerFactory.getLogger(Activator.class);
    private BundleTracker tracker;
    private Map<Long, List<BaseService>> resolvers = new ConcurrentHashMap<Long, List<BaseService>>();

    public void start(BundleContext context) throws Exception {
        LOG.info("Camel activator starting");
        this.tracker = new BundleTracker(context, 32, this);
        this.tracker.open();
        LOG.info("Camel activator started");
    }

    public void stop(BundleContext context) throws Exception {
        LOG.info("Camel activator stopping");
        this.tracker.close();
        LOG.info("Camel activator stopped");
    }

    @Override
    public Object addingBundle(Bundle bundle, BundleEvent event) {
        LOG.debug("Bundle started: {}", (Object)bundle.getSymbolicName());
        ArrayList<BaseService> r = new ArrayList<BaseService>();
        this.registerComponents(bundle, r);
        this.registerLanguages(bundle, r);
        this.registerDataFormats(bundle, r);
        this.registerTypeConverterLoader(bundle, r);
        for (BaseService service : r) {
            service.register();
        }
        this.resolvers.put(bundle.getBundleId(), r);
        return bundle;
    }

    @Override
    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
    }

    @Override
    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        LOG.debug("Bundle stopped: {}", (Object)bundle.getSymbolicName());
        List<BaseService> r = this.resolvers.remove(bundle.getBundleId());
        if (r != null) {
            for (BaseService service : r) {
                service.unregister();
            }
        }
    }

    protected void registerComponents(Bundle bundle, List<BaseService> resolvers) {
        if (Activator.checkCompat(bundle, Component.class)) {
            HashMap<String, String> components = new HashMap<String, String>();
            Enumeration e = bundle.getEntryPaths(META_INF_COMPONENT);
            while (e != null && e.hasMoreElements()) {
                String path = (String)e.nextElement();
                LOG.debug("Found entry: {} in bundle {}", (Object)path, (Object)bundle.getSymbolicName());
                String name = path.substring(path.lastIndexOf("/") + 1);
                components.put(name, path);
            }
            if (!components.isEmpty()) {
                resolvers.add(new BundleComponentResolver(bundle, components));
            }
        }
    }

    protected void registerLanguages(Bundle bundle, List<BaseService> resolvers) {
        if (Activator.checkCompat(bundle, Language.class)) {
            String name;
            String path;
            HashMap<String, String> languages = new HashMap<String, String>();
            Enumeration e = bundle.getEntryPaths(META_INF_LANGUAGE);
            while (e != null && e.hasMoreElements()) {
                path = (String)e.nextElement();
                LOG.debug("Found entry: {} in bundle {}", (Object)path, (Object)bundle.getSymbolicName());
                name = path.substring(path.lastIndexOf("/") + 1);
                languages.put(name, path);
            }
            if (!languages.isEmpty()) {
                resolvers.add(new BundleLanguageResolver(bundle, languages));
            }
            e = bundle.getEntryPaths(META_INF_LANGUAGE_RESOLVER);
            while (e != null && e.hasMoreElements()) {
                path = (String)e.nextElement();
                LOG.debug("Found entry: {} in bundle {}", (Object)path, (Object)bundle.getSymbolicName());
                name = path.substring(path.lastIndexOf("/") + 1);
                resolvers.add(new BundleMetaLanguageResolver(bundle, name, path));
            }
        }
    }

    protected void registerDataFormats(Bundle bundle, List<BaseService> resolvers) {
        if (Activator.checkCompat(bundle, DataFormat.class)) {
            HashMap<String, String> dataformats = new HashMap<String, String>();
            Enumeration e = bundle.getEntryPaths(META_INF_DATAFORMAT);
            while (e != null && e.hasMoreElements()) {
                String path = (String)e.nextElement();
                LOG.debug("Found entry: {} in bundle {}", (Object)path, (Object)bundle.getSymbolicName());
                String name = path.substring(path.lastIndexOf("/") + 1);
                dataformats.put(name, path);
            }
            if (!dataformats.isEmpty()) {
                resolvers.add(new BundleDataFormatResolver(bundle, dataformats));
            }
        }
    }

    protected void registerTypeConverterLoader(Bundle bundle, List<BaseService> resolvers) {
        if (Activator.checkCompat(bundle, TypeConverter.class)) {
            URL url1 = bundle.getEntry(META_INF_TYPE_CONVERTER);
            URL url2 = bundle.getEntry(META_INF_FALLBACK_TYPE_CONVERTER);
            if (url1 != null || url2 != null) {
                resolvers.add(new BundleTypeConverterLoader(bundle));
            }
        }
    }

    protected static Properties loadProperties(URL url) {
        Properties properties = new Properties();
        BufferedInputStream reader = null;
        try {
            reader = new BufferedInputStream(url.openStream());
            properties.load(reader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOHelper.close(reader, "properties", LOG);
        }
        return properties;
    }

    protected static boolean checkCompat(Bundle bundle, Class clazz) {
        try {
            if (bundle.loadClass(clazz.getName()) != clazz) {
                return false;
            }
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected static Set<String> getConverterPackages(URL resource) {
        LinkedHashSet<String> packages = new LinkedHashSet<String>();
        if (resource != null) {
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader(resource.openStream()));
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                    StringTokenizer iter = new StringTokenizer(line, ",");
                    while (iter.hasMoreTokens()) {
                        String name = iter.nextToken().trim();
                        if (name.length() <= 0) continue;
                        packages.add(name);
                    }
                }
            }
            catch (Exception exception) {
                IOHelper.close(reader, null, LOG);
                catch (Throwable throwable) {
                    IOHelper.close(reader, null, LOG);
                    throw throwable;
                }
            }
            IOHelper.close(reader, null, LOG);
        }
        return packages;
    }

    protected static abstract class BaseService {
        protected final Bundle bundle;
        private ServiceRegistration reg;

        protected BaseService(Bundle bundle) {
            this.bundle = bundle;
        }

        public abstract void register();

        protected void doRegister(Class type, String key, Collection<String> value) {
            this.doRegister(type, key, value.toArray(new String[value.size()]));
        }

        protected void doRegister(Class type, String key, Object value) {
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            props.put(key, value);
            this.doRegister(type, props);
        }

        protected void doRegister(Class type) {
            this.doRegister(type, null);
        }

        protected void doRegister(Class type, Dictionary props) {
            this.reg = this.bundle.getBundleContext().registerService(type.getName(), (Object)this, props);
        }

        public void unregister() {
            this.reg.unregister();
        }
    }

    protected static abstract class BaseResolver<T>
    extends BaseService {
        private final Class<T> type;

        public BaseResolver(Bundle bundle, Class<T> type) {
            super(bundle);
            this.type = type;
        }

        protected T createInstance(String name, String path, CamelContext context) {
            if (path == null) {
                return null;
            }
            URL url = this.bundle.getEntry(path);
            LOG.debug("The entry {}'s url is {}", (Object)name, (Object)url);
            return this.createInstance(name, url, context.getInjector());
        }

        protected T createInstance(String name, URL url, Injector injector) {
            try {
                Properties properties = Activator.loadProperties(url);
                String classname = (String)properties.get("class");
                Class type = this.bundle.loadClass(classname);
                if (!this.type.isAssignableFrom(type)) {
                    throw new IllegalArgumentException("Type is not a " + this.type.getName() + " implementation. Found: " + type.getName());
                }
                return injector.newInstance(type);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Invalid URI, no " + this.type.getName() + " registered for scheme : " + name, e);
            }
        }
    }

    protected static class BundleTypeConverterLoader
    extends BaseResolver<TypeConverter>
    implements TypeConverterLoader {
        private final AnnotationTypeConverterLoader loader = new Loader();
        private final Bundle bundle;

        public BundleTypeConverterLoader(Bundle bundle) {
            super(bundle, TypeConverter.class);
            ObjectHelper.notNull(bundle, "bundle");
            this.bundle = bundle;
        }

        @Override
        public synchronized void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
            try {
                this.loader.load(registry);
            }
            catch (Exception e) {
                throw new TypeConverterLoaderException("Cannot load type converters using OSGi bundle: " + this.bundle.getBundleId(), e);
            }
        }

        @Override
        public void register() {
            this.doRegister(TypeConverterLoader.class);
        }

        class Loader
        extends AnnotationTypeConverterLoader {
            Loader() {
                super(null);
            }

            @Override
            public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
                AnnotatedWithPackageScanFilter test = new AnnotatedWithPackageScanFilter(Converter.class, true);
                LinkedHashSet<Class> classes = new LinkedHashSet<Class>();
                Set<String> packages = Activator.getConverterPackages(BundleTypeConverterLoader.this.bundle.getEntry(Activator.META_INF_TYPE_CONVERTER));
                for (String pkg : packages) {
                    Enumeration e = BundleTypeConverterLoader.this.bundle.findEntries("/" + pkg.replace('.', '/'), "*.class", true);
                    while (e != null && e.hasMoreElements()) {
                        String path;
                        String externalName = path.substring((path = ((URL)e.nextElement()).getPath()).charAt(0) == '/' ? 1 : 0, path.indexOf(46)).replace('/', '.');
                        try {
                            Class clazz = BundleTypeConverterLoader.this.bundle.loadClass(externalName);
                            if (!test.matches(clazz)) continue;
                            classes.add(BundleTypeConverterLoader.this.bundle.loadClass(externalName));
                        }
                        catch (Throwable t) {}
                    }
                }
                LOG.info("Found {} @Converter classes to load", (Object)classes.size());
                for (Class type : classes) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Loading converter class: {}", (Object)ObjectHelper.name(type));
                    }
                    this.loadConverterMethods(registry, type);
                }
                URL fallbackUrl = BundleTypeConverterLoader.this.bundle.getEntry(Activator.META_INF_FALLBACK_TYPE_CONVERTER);
                if (fallbackUrl != null) {
                    TypeConverter tc = (TypeConverter)BundleTypeConverterLoader.this.createInstance("FallbackTypeConverter", fallbackUrl, registry.getInjector());
                    registry.addFallbackTypeConverter(tc, false);
                }
                this.visitedClasses.clear();
                this.visitedURIs.clear();
            }
        }
    }

    protected static class BundleDataFormatResolver
    extends BaseResolver<DataFormat>
    implements DataFormatResolver {
        private final Map<String, String> dataformats;

        public BundleDataFormatResolver(Bundle bundle, Map<String, String> dataformats) {
            super(bundle, DataFormat.class);
            this.dataformats = dataformats;
        }

        @Override
        public DataFormat resolveDataFormat(String name, CamelContext context) {
            return (DataFormat)this.createInstance(name, this.dataformats.get(name), context);
        }

        @Override
        public DataFormatDefinition resolveDataFormatDefinition(String name, CamelContext context) {
            return null;
        }

        @Override
        public void register() {
            this.doRegister(DataFormatResolver.class, "dataformat", this.dataformats.keySet());
        }
    }

    protected static class BundleMetaLanguageResolver
    extends BaseResolver<LanguageResolver>
    implements LanguageResolver {
        private final String name;
        private final String path;

        public BundleMetaLanguageResolver(Bundle bundle, String name, String path) {
            super(bundle, LanguageResolver.class);
            this.name = name;
            this.path = path;
        }

        @Override
        public Language resolveLanguage(String name, CamelContext context) {
            LanguageResolver resolver = (LanguageResolver)this.createInstance(this.name, this.path, context);
            return resolver.resolveLanguage(name, context);
        }

        @Override
        public void register() {
            this.doRegister(LanguageResolver.class, "resolver", this.name);
        }
    }

    protected static class BundleLanguageResolver
    extends BaseResolver<Language>
    implements LanguageResolver {
        private final Map<String, String> languages;

        public BundleLanguageResolver(Bundle bundle, Map<String, String> languages) {
            super(bundle, Language.class);
            this.languages = languages;
        }

        @Override
        public Language resolveLanguage(String name, CamelContext context) {
            return (Language)this.createInstance(name, this.languages.get(name), context);
        }

        @Override
        public void register() {
            this.doRegister(LanguageResolver.class, "language", this.languages.keySet());
        }
    }

    protected static class BundleComponentResolver
    extends BaseResolver<Component>
    implements ComponentResolver {
        private final Map<String, String> components;

        public BundleComponentResolver(Bundle bundle, Map<String, String> components) {
            super(bundle, Component.class);
            this.components = components;
        }

        @Override
        public Component resolveComponent(String name, CamelContext context) throws Exception {
            return (Component)this.createInstance(name, this.components.get(name), context);
        }

        @Override
        public void register() {
            this.doRegister(ComponentResolver.class, "component", this.components.keySet());
        }
    }
}

