/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ServiceStatus;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.util.ModelHelper;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(description="Managed CamelContext")
public class ManagedCamelContext {
    private final CamelContext context;

    public ManagedCamelContext(CamelContext context) {
        this.context = context;
    }

    public void init(ManagementStrategy strategy) {
    }

    public CamelContext getContext() {
        return this.context;
    }

    @ManagedAttribute(description="Camel id")
    public String getCamelId() {
        return this.context.getName();
    }

    @ManagedAttribute(description="Camel Version")
    public String getCamelVersion() {
        return this.context.getVersion();
    }

    @ManagedAttribute(description="Camel State")
    public String getState() {
        ServiceStatus status = this.context.getStatus();
        if (status == null) {
            status = ServiceStatus.Stopped;
        }
        return status.name();
    }

    @ManagedAttribute(description="Uptime")
    public String getUptime() {
        return this.context.getUptime();
    }

    @ManagedAttribute(description="Camel Properties")
    public Map<String, String> getProperties() {
        if (this.context.getProperties().isEmpty()) {
            return null;
        }
        return this.context.getProperties();
    }

    @ManagedAttribute(description="Tracing")
    public Boolean getTracing() {
        return this.context.isTracing();
    }

    @ManagedAttribute(description="Tracing")
    public void setTracing(Boolean tracing) {
        this.context.setTracing(tracing);
    }

    @ManagedAttribute(description="Current number of inflight Exchanges")
    public Integer getInflightExchanges() {
        return this.context.getInflightRepository().size();
    }

    @ManagedAttribute(description="Shutdown timeout")
    public void setTimeout(long timeout) {
        this.context.getShutdownStrategy().setTimeout(timeout);
    }

    @ManagedAttribute(description="Shutdown timeout")
    public long getTimeout() {
        return this.context.getShutdownStrategy().getTimeout();
    }

    @ManagedAttribute(description="Shutdown timeout time unit")
    public void setTimeUnit(TimeUnit timeUnit) {
        this.context.getShutdownStrategy().setTimeUnit(timeUnit);
    }

    @ManagedAttribute(description="Shutdown timeout time unit")
    public TimeUnit getTimeUnit() {
        return this.context.getShutdownStrategy().getTimeUnit();
    }

    @ManagedAttribute(description="Whether to force shutdown now when a timeout occurred")
    public void setShutdownNowOnTimeout(boolean shutdownNowOnTimeout) {
        this.context.getShutdownStrategy().setShutdownNowOnTimeout(shutdownNowOnTimeout);
    }

    @ManagedAttribute(description="Whether to force shutdown now when a timeout occurred")
    public boolean isShutdownNowOnTimeout() {
        return this.context.getShutdownStrategy().isShutdownNowOnTimeout();
    }

    @ManagedOperation(description="Start Camel")
    public void start() throws Exception {
        if (this.context.isSuspended()) {
            this.context.resume();
        } else {
            this.context.start();
        }
    }

    @ManagedOperation(description="Stop Camel (shutdown)")
    public void stop() throws Exception {
        this.context.stop();
    }

    @ManagedOperation(description="Suspend Camel")
    public void suspend() throws Exception {
        this.context.suspend();
    }

    @ManagedOperation(description="Resume Camel")
    public void resume() throws Exception {
        if (!this.context.isSuspended()) {
            throw new IllegalStateException("CamelContext is not suspended");
        }
        this.context.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(description="Send body (in only)")
    public void sendBody(String endpointUri, Object body) throws Exception {
        ProducerTemplate template = this.context.createProducerTemplate();
        try {
            template.sendBody(endpointUri, body);
        }
        finally {
            template.stop();
        }
    }

    @ManagedOperation(description="Send body (String type) (in only)")
    public void sendStringBody(String endpointUri, String body) throws Exception {
        this.sendBody(endpointUri, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(description="Send body and headers (in only)")
    public void sendBodyAndHeaders(String endpointUri, Object body, Map<String, Object> headers) throws Exception {
        ProducerTemplate template = this.context.createProducerTemplate();
        try {
            template.sendBodyAndHeaders(endpointUri, body, headers);
        }
        finally {
            template.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(description="Request body (in out)")
    public Object requestBody(String endpointUri, Object body) throws Exception {
        ProducerTemplate template = this.context.createProducerTemplate();
        Object answer = null;
        try {
            answer = template.requestBody(endpointUri, body);
        }
        finally {
            template.stop();
        }
        return answer;
    }

    @ManagedOperation(description="Request body (String type) (in out)")
    public Object requestStringBody(String endpointUri, String body) throws Exception {
        return this.requestBody(endpointUri, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(description="Request body and headers (in out)")
    public Object requestBodyAndHeaders(String endpointUri, Object body, Map<String, Object> headers) throws Exception {
        ProducerTemplate template = this.context.createProducerTemplate();
        Object answer = null;
        try {
            answer = template.requestBodyAndHeaders(endpointUri, body, headers);
        }
        finally {
            template.stop();
        }
        return answer;
    }

    @ManagedOperation(description="Dumps the routes as XML")
    public String dumpRoutesAsXml() throws Exception {
        List<RouteDefinition> routes = this.context.getRouteDefinitions();
        if (routes.isEmpty()) {
            return null;
        }
        RoutesDefinition def = new RoutesDefinition();
        def.setRoutes(routes);
        return ModelHelper.dumpModelAsXml(def);
    }

    @ManagedOperation(description="Adds or updates existing routes from XML")
    public void addOrUpdateRoutesFromXml(String xml) throws Exception {
        InputStream is = this.context.getTypeConverter().mandatoryConvertTo(InputStream.class, xml);
        RoutesDefinition def = this.context.loadRoutesDefinition(is);
        if (def == null) {
            return;
        }
        this.context.addRouteDefinitions(def.getRoutes());
    }

    @ManagedOperation(description="Creates the endpoint by the given uri")
    public boolean createEndpoint(String uri) throws Exception {
        if (this.context.hasEndpoint(uri) != null) {
            return false;
        }
        Endpoint endpoint = this.context.getEndpoint(uri);
        if (endpoint != null) {
            ObjectName on = this.context.getManagementStrategy().getManagementNamingStrategy().getObjectNameForEndpoint(endpoint);
            if (on != null && !this.context.getManagementStrategy().getManagementAgent().isRegistered(on)) {
                Object me = this.context.getManagementStrategy().getManagementObjectStrategy().getManagedObjectForEndpoint(this.context, endpoint);
                this.context.getManagementStrategy().getManagementAgent().register(me, on);
            }
            return true;
        }
        return false;
    }

    @ManagedOperation(description="Removes endpoints by the given pattern")
    public int removeEndpoints(String pattern) throws Exception {
        Collection<Endpoint> removed = this.context.removeEndpoints(pattern);
        if (removed == null) {
            return 0;
        }
        return removed.size();
    }
}

