/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.impl.ProducerCache;
import org.apache.camel.management.mbean.ManagedService;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(description="Managed ProducerCache")
public class ManagedProducerCache
extends ManagedService {
    private final ProducerCache producerCache;

    public ManagedProducerCache(CamelContext context, ProducerCache producerCache) {
        super(context, producerCache);
        this.producerCache = producerCache;
    }

    public ProducerCache getProducerCache() {
        return this.producerCache;
    }

    @ManagedAttribute(description="Source")
    public String getSource() {
        if (this.producerCache.getSource() != null) {
            return this.producerCache.getSource().toString();
        }
        return null;
    }

    @ManagedAttribute(description="Number of elements cached")
    public Integer getSize() {
        return this.producerCache.size();
    }

    @ManagedAttribute(description="Maximum cache size (capacity)")
    public Integer getMaximumCacheSize() {
        return this.producerCache.getCapacity();
    }

    @ManagedAttribute(description="Cache hits")
    public Long getHits() {
        return this.producerCache.getHits();
    }

    @ManagedAttribute(description="Cache misses")
    public Long getMisses() {
        return this.producerCache.getMisses();
    }

    @ManagedOperation(description="Reset cache statistics")
    public void resetStatistics() {
        this.producerCache.resetCacheStatistics();
    }

    @ManagedOperation(description="Purges the cache")
    public void purge() {
        this.producerCache.purge();
    }
}

