/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.util.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoopProcessor
extends DelegateAsyncProcessor
implements Traceable {
    private static final Logger LOG = LoggerFactory.getLogger(LoopProcessor.class);
    private final Expression expression;
    private final boolean copy;

    public LoopProcessor(Processor processor, Expression expression, boolean copy) {
        super(processor);
        this.expression = expression;
        this.copy = copy;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        AtomicInteger index = new AtomicInteger();
        AtomicInteger count = new AtomicInteger();
        String text = this.expression.evaluate(exchange, String.class);
        try {
            int num = ExchangeHelper.convertToMandatoryType(exchange, Integer.class, text);
            count.set(num);
        }
        catch (NoTypeConversionAvailableException e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
        Exchange target = exchange;
        exchange.setProperty("CamelLoopSize", count);
        while (index.get() < count.get()) {
            target = this.prepareExchange(exchange, index.get());
            boolean sync = this.process(target, callback, index, count);
            if (!sync) {
                LOG.trace("Processing exchangeId: {} is continued being processed asynchronously", (Object)target.getExchangeId());
                return false;
            }
            LOG.trace("Processing exchangeId: {} is continued being processed synchronously", (Object)target.getExchangeId());
            index.getAndIncrement();
        }
        ExchangeHelper.copyResults(exchange, target);
        LOG.trace("Processing complete for exchangeId: {} >>> {}", (Object)exchange.getExchangeId(), (Object)exchange);
        callback.done(true);
        return true;
    }

    protected boolean process(final Exchange exchange, final AsyncCallback callback, final AtomicInteger index, final AtomicInteger count) {
        LOG.debug("LoopProcessor: iteration #{}", (Object)index.get());
        exchange.setProperty("CamelLoopIndex", index.get());
        boolean sync = this.processNext(exchange, new AsyncCallback(){

            @Override
            public void done(boolean doneSync) {
                if (doneSync) {
                    return;
                }
                Exchange target = exchange;
                index.getAndIncrement();
                while (index.get() < count.get()) {
                    target = LoopProcessor.this.prepareExchange(exchange, index.get());
                    boolean sync = LoopProcessor.this.process(target, callback, index, count);
                    if (!sync) {
                        LOG.trace("Processing exchangeId: {} is continued being processed asynchronously", (Object)target.getExchangeId());
                        return;
                    }
                    index.getAndIncrement();
                }
                ExchangeHelper.copyResults(exchange, target);
                LOG.trace("Processing complete for exchangeId: {} >>> {}", (Object)exchange.getExchangeId(), (Object)exchange);
                callback.done(false);
            }
        });
        return sync;
    }

    protected Exchange prepareExchange(Exchange exchange, int index) {
        if (this.copy) {
            return ExchangeHelper.createCorrelatedCopy(exchange, false);
        }
        ExchangeHelper.prepareOutToIn(exchange);
        return exchange;
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public String getTraceLabel() {
        return "loop[" + this.expression + "]";
    }

    @Override
    public String toString() {
        return "Loop[for: " + this.expression + " times do: " + this.getProcessor() + "]";
    }
}

