/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Component;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ResourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceEndpoint
extends ProcessorEndpoint {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private String resourceUri;
    private boolean contentCache;
    private byte[] buffer;

    public ResourceEndpoint() {
    }

    public ResourceEndpoint(String endpointUri, Component component, String resourceUri) {
        super(endpointUri, component);
        this.resourceUri = resourceUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getResourceAsInputStream() throws IOException {
        if (this.contentCache) {
            ResourceEndpoint resourceEndpoint = this;
            synchronized (resourceEndpoint) {
                if (this.buffer == null) {
                    this.log.debug("Reading resource: {} into the content cache", (Object)this.resourceUri);
                    InputStream is = this.getResourceAsInputStreamWithoutCache();
                    this.buffer = IOConverter.toBytes(is);
                    IOHelper.close(is, this.resourceUri, this.log);
                }
            }
            this.log.debug("Using resource: {} from the content cache", (Object)this.resourceUri);
            return new ByteArrayInputStream(this.buffer);
        }
        return this.getResourceAsInputStreamWithoutCache();
    }

    protected InputStream getResourceAsInputStreamWithoutCache() throws IOException {
        return ResourceHelper.resolveMandatoryResourceAsInputStream(this.getCamelContext().getClassResolver(), this.resourceUri);
    }

    public boolean isContentCache() {
        return this.contentCache;
    }

    public void setContentCache(boolean contentCache) {
        this.contentCache = contentCache;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public void setResourceUri(String resourceUri) {
        this.resourceUri = resourceUri;
    }
}

