/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.language;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.language.LanguageProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Language;
import org.apache.camel.util.ObjectHelper;

public class LanguageEndpoint
extends DefaultEndpoint {
    private Language language;
    private Expression expression;
    private String languageName;
    private String script;
    private boolean transform = true;

    public LanguageEndpoint() {
    }

    public LanguageEndpoint(String endpointUri, Component component, Language language, Expression expression) {
        super(endpointUri, component);
        this.language = language;
        this.expression = expression;
    }

    @Override
    public Producer createProducer() throws Exception {
        ObjectHelper.notNull(this.getCamelContext(), "CamelContext", this);
        if (this.language == null && this.languageName != null) {
            this.language = this.getCamelContext().resolveLanguage(this.languageName);
        }
        ObjectHelper.notNull(this.language, "language", this);
        if (this.expression == null && this.script != null) {
            this.expression = this.language.createExpression(this.script);
        }
        return new LanguageProducer(this);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        throw new RuntimeCamelException("Cannot consume to a LanguageEndpoint: " + this.getEndpointUri());
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    protected String createEndpointUri() {
        String s = this.script;
        try {
            s = URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.languageName + ":" + s;
    }

    public Language getLanguage() {
        return this.language;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public boolean isTransform() {
        return this.transform;
    }

    public void setTransform(boolean transform) {
        this.transform = transform;
    }

    public void setLanguageName(String languageName) {
        this.languageName = languageName;
    }

    public void setScript(String script) {
        this.script = script;
    }
}

