/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.validator;

import java.io.InputStream;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.processor.validation.ValidatingProcessor;
import org.apache.camel.util.ResourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorComponent
extends DefaultComponent {
    private static final transient Logger LOG = LoggerFactory.getLogger(ValidatorComponent.class);

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String resourceUri = remaining;
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream(this.getCamelContext().getClassResolver(), resourceUri);
        StreamSource source = new StreamSource(is);
        ValidatingProcessor validator = new ValidatingProcessor();
        validator.setSchemaSource(source);
        LOG.debug("{} using schema resource: {}", (Object)this, (Object)resourceUri);
        this.configureValidator(validator, uri, remaining, parameters);
        validator.loadSchema();
        return new ProcessorEndpoint(uri, this, (Processor)validator);
    }

    protected void configureValidator(ValidatingProcessor validator, String uri, String remaining, Map<String, Object> parameters) throws Exception {
        this.setProperties(validator, parameters);
    }
}

