/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.AsyncProcessor;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.impl.LoggingExceptionHandler;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorConverterHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConsumer
extends ServiceSupport
implements Consumer {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final Endpoint endpoint;
    private final Processor processor;
    private volatile AsyncProcessor asyncProcessor;
    private ExceptionHandler exceptionHandler;

    public DefaultConsumer(Endpoint endpoint, Processor processor) {
        this.endpoint = endpoint;
        this.processor = processor;
    }

    public String toString() {
        return "Consumer[" + this.endpoint.getEndpointUri() + "]";
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public synchronized AsyncProcessor getAsyncProcessor() {
        if (this.asyncProcessor == null) {
            this.asyncProcessor = AsyncProcessorConverterHelper.convert(this.processor);
        }
        return this.asyncProcessor;
    }

    public ExceptionHandler getExceptionHandler() {
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new LoggingExceptionHandler(this.getClass());
        }
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    protected void doStop() throws Exception {
        this.log.debug("Stopping consumer: {}", (Object)this);
        ServiceHelper.stopServices(this.processor);
    }

    @Override
    protected void doStart() throws Exception {
        this.log.debug("Starting consumer: {}", (Object)this);
        ServiceHelper.startServices(this.processor);
    }

    protected void handleException(Throwable t) {
        Throwable newt = t == null ? new IllegalArgumentException("Handling [null] exception") : t;
        this.getExceptionHandler().handleException(newt);
    }
}

