/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Channel;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.TimerListener;
import org.apache.camel.VetoCamelContextStartException;
import org.apache.camel.api.management.PerformanceCounter;
import org.apache.camel.impl.ConsumerCache;
import org.apache.camel.impl.DefaultCamelContextNameStrategy;
import org.apache.camel.impl.EndpointRegistry;
import org.apache.camel.impl.EventDrivenConsumerRoute;
import org.apache.camel.impl.ExplicitCamelContextNameStrategy;
import org.apache.camel.impl.ProducerCache;
import org.apache.camel.impl.ThrottlingInflightRoutePolicy;
import org.apache.camel.management.DelegatePerformanceCounter;
import org.apache.camel.management.InstrumentationInterceptStrategy;
import org.apache.camel.management.InstrumentationProcessor;
import org.apache.camel.management.mbean.ManagedConsumerCache;
import org.apache.camel.management.mbean.ManagedEndpointRegistry;
import org.apache.camel.management.mbean.ManagedProducerCache;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.management.mbean.ManagedThrottlingInflightRoutePolicy;
import org.apache.camel.management.mbean.ManagedTracer;
import org.apache.camel.model.AOPDefinition;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.CamelContextNameStrategy;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.ManagementAgent;
import org.apache.camel.spi.ManagementAware;
import org.apache.camel.spi.ManagementObjectStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.support.TimerListenerManager;
import org.apache.camel.util.KeyValueHolder;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultManagementLifecycleStrategy
extends ServiceSupport
implements LifecycleStrategy,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultManagementLifecycleStrategy.class);
    private final Map<Processor, KeyValueHolder<ProcessorDefinition, InstrumentationProcessor>> wrappedProcessors = new HashMap<Processor, KeyValueHolder<ProcessorDefinition, InstrumentationProcessor>>();
    private final List<PreRegisterService> preServices = new ArrayList<PreRegisterService>();
    private final TimerListenerManager timerListenerManager = new TimerListenerManager();
    private CamelContext camelContext;
    private volatile boolean initialized;
    private final Set<String> knowRouteIds = new HashSet<String>();
    private Map<Object, ManagedTracer> managedTracers = new HashMap<Object, ManagedTracer>();

    public DefaultManagementLifecycleStrategy() {
    }

    public DefaultManagementLifecycleStrategy(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void onContextStart(CamelContext context) throws VetoCamelContextStartException {
        Object mc = this.getManagementObjectStrategy().getManagedObjectForCamelContext(context);
        String managementName = context.getManagementName() != null ? context.getManagementName() : context.getName();
        try {
            boolean done = false;
            while (!done) {
                ObjectName on = this.getManagementStrategy().getManagementNamingStrategy().getObjectNameForCamelContext(context);
                boolean exists = this.getManagementStrategy().isManaged(mc, on);
                if (!exists) {
                    done = true;
                    continue;
                }
                boolean fixed = false;
                String name = this.findFreeName(mc, context.getNameStrategy(), managementName);
                if (name != null) {
                    fixed = true;
                    done = true;
                    managementName = name;
                }
                if (!fixed) {
                    throw new VetoCamelContextStartException("CamelContext (" + context.getName() + ") with ObjectName[" + on + "] is already registered." + " Make sure to use unique names on CamelContext when using multiple CamelContexts in the same MBeanServer.", context);
                }
                if (context.getNameStrategy() instanceof DefaultCamelContextNameStrategy) {
                    LOG.warn("Reassigned auto assigned name on CamelContext from: " + context.getName() + " to: " + name + " due to clash with existing name already registered in MBeanServer.");
                    context.setNameStrategy(new ExplicitCamelContextNameStrategy(name));
                    continue;
                }
                LOG.warn("This CamelContext(" + context.getName() + ") will be registered using the name: " + managementName + " due to clash with an existing name already registered in MBeanServer.");
            }
        }
        catch (VetoCamelContextStartException e) {
            throw e;
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        context.setManagementName(managementName);
        try {
            this.manageObject(mc);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        this.initialized = true;
        this.enlistPreRegisteredServices();
    }

    private String findFreeName(Object mc, CamelContextNameStrategy strategy, String managementName) throws MalformedObjectNameException {
        boolean done = false;
        String name = null;
        int counter = 2;
        while (!done) {
            name = strategy instanceof DefaultCamelContextNameStrategy ? ((DefaultCamelContextNameStrategy)strategy).getNextName() : managementName + "-" + counter++;
            ObjectName on = this.getManagementStrategy().getManagementNamingStrategy().getObjectNameForCamelContext(name);
            boolean bl = done = !this.getManagementStrategy().isManaged(mc, on);
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace("Using name: {} in ObjectName[{}] exists? {}", new Object[]{name, on, done});
        }
        return name;
    }

    private void enlistPreRegisteredServices() {
        if (this.preServices.isEmpty()) {
            return;
        }
        LOG.debug("Registering {} pre registered services", (Object)this.preServices.size());
        for (PreRegisterService pre : this.preServices) {
            if (pre.getComponent() != null) {
                this.onComponentAdd(pre.getName(), pre.getComponent());
                continue;
            }
            if (pre.getEndpoint() != null) {
                this.onEndpointAdd(pre.getEndpoint());
                continue;
            }
            if (pre.getService() == null) continue;
            this.onServiceAdd(pre.getCamelContext(), pre.getService(), pre.getRoute());
        }
        this.preServices.clear();
    }

    @Override
    public void onContextStop(CamelContext context) {
        if (!this.initialized) {
            return;
        }
        try {
            Object mc = this.getManagementObjectStrategy().getManagedObjectForCamelContext(context);
            if (this.getManagementStrategy().isManaged(mc, null)) {
                this.unmanageObject(mc);
            }
        }
        catch (Exception e) {
            LOG.warn("Could not unregister CamelContext MBean", (Throwable)e);
        }
    }

    @Override
    public void onComponentAdd(String name, Component component) {
        if (!this.initialized) {
            PreRegisterService pre = new PreRegisterService();
            pre.onComponentAdd(name, component);
            this.preServices.add(pre);
            return;
        }
        try {
            Object mc = this.getManagementObjectStrategy().getManagedObjectForComponent(this.camelContext, component, name);
            this.manageObject(mc);
        }
        catch (Exception e) {
            LOG.warn("Could not register Component MBean", (Throwable)e);
        }
    }

    @Override
    public void onComponentRemove(String name, Component component) {
        if (!this.initialized) {
            return;
        }
        try {
            Object mc = this.getManagementObjectStrategy().getManagedObjectForComponent(this.camelContext, component, name);
            this.unmanageObject(mc);
        }
        catch (Exception e) {
            LOG.warn("Could not unregister Component MBean", (Throwable)e);
        }
    }

    @Override
    public void onEndpointAdd(Endpoint endpoint) {
        if (!this.initialized) {
            PreRegisterService pre = new PreRegisterService();
            pre.onEndpointAdd(endpoint);
            this.preServices.add(pre);
            return;
        }
        if (!this.shouldRegister(endpoint, null)) {
            return;
        }
        try {
            Object me = this.getManagementObjectStrategy().getManagedObjectForEndpoint(this.camelContext, endpoint);
            if (me == null) {
                return;
            }
            this.manageObject(me);
        }
        catch (Exception e) {
            LOG.warn("Could not register Endpoint MBean for uri: " + endpoint.getEndpointUri(), (Throwable)e);
        }
    }

    @Override
    public void onEndpointRemove(Endpoint endpoint) {
        if (!this.initialized) {
            return;
        }
        try {
            Object me = this.getManagementObjectStrategy().getManagedObjectForEndpoint(this.camelContext, endpoint);
            this.unmanageObject(me);
        }
        catch (Exception e) {
            LOG.warn("Could not unregister Endpoint MBean for uri: " + endpoint.getEndpointUri(), (Throwable)e);
        }
    }

    @Override
    public void onServiceAdd(CamelContext context, Service service, Route route) {
        if (!this.initialized) {
            PreRegisterService pre = new PreRegisterService();
            pre.onServiceAdd(context, service, route);
            this.preServices.add(pre);
            return;
        }
        if (!this.shouldRegister(service, route)) {
            return;
        }
        Object managedObject = this.getManagedObjectForService(context, service, route);
        if (managedObject == null) {
            return;
        }
        if (this.getManagementStrategy().isManaged(managedObject, null)) {
            LOG.trace("The service is already managed: {}", (Object)service);
            return;
        }
        try {
            this.manageObject(managedObject);
        }
        catch (Exception e) {
            LOG.warn("Could not register service: " + service + " as Service MBean.", (Throwable)e);
        }
    }

    @Override
    public void onServiceRemove(CamelContext context, Service service, Route route) {
        if (!this.initialized) {
            return;
        }
        Object managedObject = this.getManagedObjectForService(context, service, route);
        if (managedObject != null) {
            try {
                this.unmanageObject(managedObject);
            }
            catch (Exception e) {
                LOG.warn("Could not unregister service: " + service + " as Service MBean.", (Throwable)e);
            }
        }
    }

    private Object getManagedObjectForService(CamelContext context, Service service, Route route) {
        if (service instanceof Channel || service instanceof UnitOfWork || service instanceof InstrumentationProcessor) {
            return null;
        }
        Object answer = null;
        if (service instanceof ManagementAware) {
            return ((ManagementAware)((Object)service)).getManagedObject(service);
        }
        if (service instanceof Tracer) {
            ManagedTracer mo = this.managedTracers.get(service);
            if (mo == null) {
                ManagedTracer mt = new ManagedTracer(context, (Tracer)service);
                mt.init(this.getManagementStrategy());
                this.managedTracers.put(service, mt);
                mo = mt;
            }
            return mo;
        }
        if (service instanceof EventNotifier) {
            answer = this.getManagementObjectStrategy().getManagedObjectForEventNotifier(context, (EventNotifier)((Object)service));
        } else if (service instanceof Producer) {
            answer = this.getManagementObjectStrategy().getManagedObjectForProducer(context, (Producer)service);
        } else if (service instanceof Consumer) {
            answer = this.getManagementObjectStrategy().getManagedObjectForConsumer(context, (Consumer)service);
        } else {
            if (service instanceof Processor) {
                return this.getManagedObjectForProcessor(context, (Processor)((Object)service), route);
            }
            if (service instanceof ThrottlingInflightRoutePolicy) {
                answer = new ManagedThrottlingInflightRoutePolicy(context, (ThrottlingInflightRoutePolicy)service);
            } else if (service instanceof ConsumerCache) {
                answer = new ManagedConsumerCache(context, (ConsumerCache)service);
            } else if (service instanceof ProducerCache) {
                answer = new ManagedProducerCache(context, (ProducerCache)service);
            } else if (service instanceof EndpointRegistry) {
                answer = new ManagedEndpointRegistry(context, (EndpointRegistry)service);
            } else if (service != null) {
                answer = this.getManagementObjectStrategy().getManagedObjectForService(context, service);
            }
        }
        if (answer != null && answer instanceof ManagedService) {
            ManagedService ms = (ManagedService)answer;
            ms.setRoute(route);
            ms.init(this.getManagementStrategy());
            return answer;
        }
        return answer;
    }

    private Object getManagedObjectForProcessor(CamelContext context, Processor processor, Route route) {
        InstrumentationProcessor counter;
        KeyValueHolder<ProcessorDefinition, InstrumentationProcessor> holder = this.wrappedProcessors.get(processor);
        if (holder == null) {
            return null;
        }
        Object managedObject = this.getManagementObjectStrategy().getManagedObjectForProcessor(context, processor, holder.getKey(), route);
        if (managedObject != null && managedObject instanceof PerformanceCounter && (counter = holder.getValue()) != null) {
            counter.setCounter(managedObject);
        }
        return managedObject;
    }

    @Override
    public void onRoutesAdd(Collection<Route> routes) {
        for (Route route : routes) {
            EventDrivenConsumerRoute edcr;
            Processor processor;
            if (this.getCamelContext().getStatus().isStarting() || this.getManagementStrategy().getManagementAgent().getRegisterAlways().booleanValue() || this.getManagementStrategy().getManagementAgent().getRegisterNewRoutes().booleanValue()) {
                this.knowRouteIds.add(route.getId());
            }
            if (!this.shouldRegister(route, route)) continue;
            Object mr = this.getManagementObjectStrategy().getManagedObjectForRoute(this.camelContext, route);
            if (this.getManagementStrategy().isManaged(mr, null)) {
                LOG.trace("The route is already managed: {}", (Object)route);
                continue;
            }
            if (route instanceof EventDrivenConsumerRoute && (processor = (edcr = (EventDrivenConsumerRoute)route).getProcessor()) instanceof InstrumentationProcessor) {
                InstrumentationProcessor ip = (InstrumentationProcessor)processor;
                ip.setCounter(mr);
            }
            try {
                this.manageObject(mr);
            }
            catch (JMException e) {
                LOG.warn("Could not register Route MBean", (Throwable)e);
            }
            catch (Exception e) {
                LOG.warn("Could not create Route MBean", (Throwable)e);
            }
        }
    }

    @Override
    public void onRoutesRemove(Collection<Route> routes) {
        if (!this.initialized) {
            return;
        }
        for (Route route : routes) {
            Object mr = this.getManagementObjectStrategy().getManagedObjectForRoute(this.camelContext, route);
            if (!this.getManagementStrategy().isManaged(mr, null)) {
                LOG.trace("The route is not managed: {}", (Object)route);
                continue;
            }
            try {
                this.unmanageObject(mr);
            }
            catch (Exception e) {
                LOG.warn("Could not unregister Route MBean", (Throwable)e);
            }
        }
    }

    @Override
    public void onErrorHandlerAdd(RouteContext routeContext, Processor errorHandler, ErrorHandlerFactory errorHandlerBuilder) {
        if (!this.shouldRegister(errorHandler, null)) {
            return;
        }
        Object me = this.getManagementObjectStrategy().getManagedObjectForErrorHandler(this.camelContext, routeContext, errorHandler, errorHandlerBuilder);
        if (this.getManagementStrategy().isManaged(me, null)) {
            LOG.trace("The error handler builder is already managed: {}", (Object)errorHandlerBuilder);
            return;
        }
        try {
            this.manageObject(me);
        }
        catch (Exception e) {
            LOG.warn("Could not register error handler builder: " + errorHandlerBuilder + " as ErrorHandler MBean.", (Throwable)e);
        }
    }

    @Override
    public void onThreadPoolAdd(CamelContext camelContext, ThreadPoolExecutor threadPool, String id, String sourceId, String routeId, String threadPoolProfileId) {
        if (!this.initialized) {
            return;
        }
        Object mtp = this.getManagementObjectStrategy().getManagedObjectForThreadPool(camelContext, threadPool, id, sourceId, routeId, threadPoolProfileId);
        if (this.getManagementStrategy().isManaged(mtp, null)) {
            LOG.trace("The thread pool is already managed: {}", (Object)threadPool);
            return;
        }
        try {
            this.manageObject(mtp);
        }
        catch (Exception e) {
            LOG.warn("Could not register thread pool: " + threadPool + " as ThreadPool MBean.", (Throwable)e);
        }
    }

    @Override
    public void onRouteContextCreate(RouteContext routeContext) {
        if (!this.initialized) {
            return;
        }
        HashMap<ProcessorDefinition, PerformanceCounter> registeredCounters = new HashMap<ProcessorDefinition, PerformanceCounter>();
        RouteDefinition route = routeContext.getRoute();
        for (ProcessorDefinition processor : route.getOutputs()) {
            this.registerPerformanceCounters(routeContext, processor, registeredCounters);
        }
        routeContext.setManagedInterceptStrategy(new InstrumentationInterceptStrategy(registeredCounters, this.wrappedProcessors));
    }

    private void registerPerformanceCounters(RouteContext routeContext, ProcessorDefinition processor, Map<ProcessorDefinition, PerformanceCounter> registeredCounters) {
        List<ProcessorDefinition> children = processor.getOutputs();
        for (ProcessorDefinition child : children) {
            this.registerPerformanceCounters(routeContext, child, registeredCounters);
        }
        if (!this.registerProcessor(processor)) {
            return;
        }
        DelegatePerformanceCounter pc = new DelegatePerformanceCounter();
        boolean enabled = this.camelContext.getManagementStrategy().getStatisticsLevel() == ManagementStatisticsLevel.All;
        pc.setStatisticsEnabled(enabled);
        registeredCounters.put(processor, pc);
    }

    protected boolean registerProcessor(ProcessorDefinition processor) {
        if (processor instanceof OnExceptionDefinition) {
            return false;
        }
        if (processor instanceof OnCompletionDefinition) {
            return false;
        }
        if (processor instanceof InterceptDefinition) {
            return false;
        }
        if (processor instanceof AOPDefinition) {
            return false;
        }
        if (processor instanceof PolicyDefinition) {
            return false;
        }
        if (this.getManagementStrategy().isOnlyManageProcessorWithCustomId()) {
            return processor.hasCustomIdAssigned();
        }
        return this.getManagementStrategy().manageProcessor(processor);
    }

    private ManagementStrategy getManagementStrategy() {
        ObjectHelper.notNull(this.camelContext, "CamelContext");
        return this.camelContext.getManagementStrategy();
    }

    private ManagementObjectStrategy getManagementObjectStrategy() {
        ObjectHelper.notNull(this.camelContext, "CamelContext");
        return this.camelContext.getManagementStrategy().getManagementObjectStrategy();
    }

    protected void manageObject(Object me) throws Exception {
        this.getManagementStrategy().manageObject(me);
        if (this.timerListenerManager != null && me instanceof TimerListener) {
            TimerListener timer = (TimerListener)me;
            this.timerListenerManager.addTimerListener(timer);
        }
    }

    protected void unmanageObject(Object me) throws Exception {
        if (this.timerListenerManager != null && me instanceof TimerListener) {
            TimerListener timer = (TimerListener)me;
            this.timerListenerManager.removeTimerListener(timer);
        }
        this.getManagementStrategy().unmanageObject(me);
    }

    protected boolean shouldRegister(Object service, Route route) {
        if (!this.initialized) {
            return false;
        }
        LOG.trace("Checking whether to register {} from route: {}", service, (Object)route);
        if (this.getCamelContext().getStatus().isStarting()) {
            return true;
        }
        ManagementAgent agent = this.getManagementStrategy().getManagementAgent();
        if (agent.getRegisterAlways().booleanValue()) {
            return true;
        }
        if (route != null && this.knowRouteIds.contains(route.getId())) {
            return true;
        }
        if (agent.getRegisterNewRoutes().booleanValue()) {
            return this.getCamelContext().isStartingRoutes();
        }
        return false;
    }

    @Override
    protected void doStart() throws Exception {
        boolean enabled;
        ObjectHelper.notNull(this.camelContext, "CamelContext");
        boolean bl = enabled = this.camelContext.getManagementStrategy().getStatisticsLevel() != ManagementStatisticsLevel.Off;
        if (enabled) {
            LOG.info("StatiticsLevel at {} so enabling load performance statistics", (Object)this.camelContext.getManagementStrategy().getStatisticsLevel());
            ScheduledExecutorService executorService = this.camelContext.getExecutorServiceManager().newDefaultScheduledThreadPool(this, "ManagementLoadTask");
            this.timerListenerManager.setExecutorService(executorService);
            this.timerListenerManager.setInterval(1000L);
            ServiceHelper.startService(this.timerListenerManager);
        }
    }

    @Override
    protected void doStop() throws Exception {
        this.initialized = false;
        this.knowRouteIds.clear();
        this.preServices.clear();
        ServiceHelper.stopService(this.timerListenerManager);
    }

    private static final class PreRegisterService {
        private String name;
        private Component component;
        private Endpoint endpoint;
        private CamelContext camelContext;
        private Service service;
        private Route route;

        private PreRegisterService() {
        }

        public void onComponentAdd(String name, Component component) {
            this.name = name;
            this.component = component;
        }

        public void onEndpointAdd(Endpoint endpoint) {
            this.endpoint = endpoint;
        }

        public void onServiceAdd(CamelContext camelContext, Service service, Route route) {
            this.camelContext = camelContext;
            this.service = service;
            this.route = route;
        }

        public String getName() {
            return this.name;
        }

        public Component getComponent() {
            return this.component;
        }

        public Endpoint getEndpoint() {
            return this.endpoint;
        }

        public CamelContext getCamelContext() {
            return this.camelContext;
        }

        public Service getService() {
            return this.service;
        }

        public Route getRoute() {
            return this.route;
        }
    }
}

