/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Descriptor;
import javax.management.IntrospectionException;
import javax.management.JMException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedNotification;
import org.apache.camel.api.management.ManagedNotifications;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeanInfoAssembler {
    private static final Logger LOG = LoggerFactory.getLogger(MBeanInfoAssembler.class);

    public ModelMBeanInfo getMBeanInfo(Object managedBean, String objectName) throws JMException {
        HashMap<String, ManagedAttributeInfo> attributes = new HashMap<String, ManagedAttributeInfo>();
        ArrayList<ManagedOperationInfo> operations = new ArrayList<ManagedOperationInfo>();
        ArrayList<ModelMBeanAttributeInfo> mBeanAttributes = new ArrayList<ModelMBeanAttributeInfo>();
        ArrayList<ModelMBeanOperationInfo> mBeanOperations = new ArrayList<ModelMBeanOperationInfo>();
        this.extractAttributesAndOperations(managedBean, attributes, operations);
        this.extractMbeanAttributes(managedBean, attributes, mBeanAttributes, mBeanOperations);
        this.extractMbeanOperations(managedBean, operations, mBeanOperations);
        List<ModelMBeanNotificationInfo> mBeanNotifications = this.extractMbeanNotifiations(managedBean);
        String name = this.getName(managedBean, objectName);
        String description = this.getDescription(managedBean, objectName);
        ModelMBeanAttributeInfo[] arrayAttributes = mBeanAttributes.toArray(new ModelMBeanAttributeInfo[mBeanAttributes.size()]);
        ModelMBeanOperationInfo[] arrayOperations = mBeanOperations.toArray(new ModelMBeanOperationInfo[mBeanOperations.size()]);
        ModelMBeanNotificationInfo[] arrayNotifications = mBeanNotifications.toArray(new ModelMBeanNotificationInfo[mBeanNotifications.size()]);
        ModelMBeanInfoSupport info = new ModelMBeanInfoSupport(name, description, arrayAttributes, null, arrayOperations, arrayNotifications);
        LOG.trace("Created ModelMBeanInfo {}", (Object)info);
        return info;
    }

    private List<ModelMBeanNotificationInfo> extractMbeanNotifiations(Object managedBean) {
        ArrayList<ModelMBeanNotificationInfo> mBeanNotifications = new ArrayList<ModelMBeanNotificationInfo>();
        ManagedNotifications notifications = managedBean.getClass().getAnnotation(ManagedNotifications.class);
        if (notifications != null) {
            for (ManagedNotification notification : notifications.value()) {
                mBeanNotifications.add(new ModelMBeanNotificationInfo(notification.notificationTypes(), notification.name(), notification.description()));
            }
        }
        return mBeanNotifications;
    }

    private void extractAttributesAndOperations(Object managedBean, Map<String, ManagedAttributeInfo> attributes, List<ManagedOperationInfo> operations) {
        for (Method method : managedBean.getClass().getMethods()) {
            ManagedOperation mo;
            String desc;
            ManagedAttribute ma = method.getAnnotation(ManagedAttribute.class);
            if (ma != null) {
                String key;
                desc = ma.description();
                Method getter = null;
                Method setter = null;
                if (IntrospectionSupport.isGetter(method)) {
                    key = IntrospectionSupport.getGetterShorthandName(method);
                    getter = method;
                } else if (IntrospectionSupport.isSetter(method)) {
                    key = IntrospectionSupport.getSetterShorthandName(method);
                    setter = method;
                } else {
                    throw new IllegalArgumentException("@ManagedAttribute can only be used on Java bean methods, was: " + method + " on bean: " + managedBean);
                }
                key = ObjectHelper.capitalize(key);
                ManagedAttributeInfo info = attributes.get(key);
                if (info == null) {
                    info = new ManagedAttributeInfo(key, desc);
                }
                if (getter != null) {
                    info.setGetter(getter);
                }
                if (setter != null) {
                    info.setSetter(setter);
                }
                attributes.put(key, info);
            }
            if ((mo = method.getAnnotation(ManagedOperation.class)) == null) continue;
            desc = mo.description();
            Method operation = method;
            operations.add(new ManagedOperationInfo(desc, operation));
        }
    }

    private void extractMbeanAttributes(Object managedBean, Map<String, ManagedAttributeInfo> attributes, List<ModelMBeanAttributeInfo> mBeanAttributes, List<ModelMBeanOperationInfo> mBeanOperations) throws IntrospectionException {
        for (ManagedAttributeInfo info : attributes.values()) {
            ModelMBeanOperationInfo mbeanOperation;
            ModelMBeanAttributeInfo mbeanAttribute = new ModelMBeanAttributeInfo(info.getKey(), info.getDescription(), info.getGetter(), info.getSetter());
            Descriptor desc = mbeanAttribute.getDescriptor();
            if (info.getGetter() != null) {
                desc.setField("getMethod", info.getGetter().getName());
                mbeanOperation = new ModelMBeanOperationInfo(info.getKey(), info.getGetter());
                mBeanOperations.add(mbeanOperation);
            }
            if (info.getSetter() != null) {
                desc.setField("setMethod", info.getSetter().getName());
                mbeanOperation = new ModelMBeanOperationInfo(info.getKey(), info.getSetter());
                mBeanOperations.add(mbeanOperation);
            }
            mbeanAttribute.setDescriptor(desc);
            mBeanAttributes.add(mbeanAttribute);
            LOG.trace("Assembled attribute: {}", (Object)mbeanAttribute);
        }
    }

    private void extractMbeanOperations(Object managedBean, List<ManagedOperationInfo> operations, List<ModelMBeanOperationInfo> mBeanOperations) {
        for (ManagedOperationInfo info : operations) {
            ModelMBeanOperationInfo mbean = new ModelMBeanOperationInfo(info.getDescription(), info.getOperation());
            mBeanOperations.add(mbean);
            LOG.trace("Assembled operation: {}", (Object)mbean);
        }
    }

    private String getDescription(Object managedBean, String objectName) {
        ManagedResource mr = ObjectHelper.getAnnotation(managedBean, ManagedResource.class);
        return mr != null ? mr.description() : "";
    }

    private String getName(Object managedBean, String objectName) {
        return managedBean.getClass().getName();
    }

    private static final class ManagedOperationInfo {
        private final String description;
        private final Method operation;

        private ManagedOperationInfo(String description, Method operation) {
            this.description = description;
            this.operation = operation;
        }

        public String getDescription() {
            return this.description;
        }

        public Method getOperation() {
            return this.operation;
        }

        public String toString() {
            return "ManagedOperationInfo: [" + this.operation + "]";
        }
    }

    private static final class ManagedAttributeInfo {
        private String key;
        private String description;
        private Method getter;
        private Method setter;

        private ManagedAttributeInfo(String key, String description) {
            this.key = key;
            this.description = description;
        }

        public String getKey() {
            return this.key;
        }

        public String getDescription() {
            return this.description;
        }

        public Method getGetter() {
            return this.getter;
        }

        public void setGetter(Method getter) {
            this.getter = getter;
        }

        public Method getSetter() {
            return this.setter;
        }

        public void setSetter(Method setter) {
            this.setter = setter;
        }

        public String toString() {
            return "ManagedAttributeInfo: [" + this.key + " + getter: " + this.getter + ", setter: " + this.setter + "]";
        }
    }
}

