/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.Component;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StatefulService;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedInstance;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.spi.ManagementStrategy;

@ManagedResource(description="Managed Component")
public class ManagedComponent
implements ManagedInstance {
    private final Component component;
    private final String name;

    public ManagedComponent(String name, Component component) {
        this.name = name;
        this.component = component;
    }

    public void init(ManagementStrategy strategy) {
    }

    public Component getComponent() {
        return this.component;
    }

    @ManagedAttribute(description="Component Name")
    public String getComponentName() {
        return this.name;
    }

    @ManagedAttribute(description="Component State")
    public String getState() {
        if (this.component instanceof StatefulService) {
            ServiceStatus status = ((StatefulService)((Object)this.component)).getStatus();
            if (status == null) {
                status = ServiceStatus.Stopped;
            }
            return status.name();
        }
        return ServiceStatus.Started.name();
    }

    @ManagedAttribute(description="Camel id")
    public String getCamelId() {
        return this.component.getCamelContext().getName();
    }

    @Override
    public Object getInstance() {
        return this.component;
    }
}

