/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.impl.ConsumerCache;
import org.apache.camel.management.mbean.ManagedService;

@ManagedResource(description="Managed ConsumerCache")
public class ManagedConsumerCache
extends ManagedService {
    private final ConsumerCache consumerCache;

    public ManagedConsumerCache(CamelContext context, ConsumerCache consumerCache) {
        super(context, consumerCache);
        this.consumerCache = consumerCache;
    }

    public ConsumerCache getConsumerCache() {
        return this.consumerCache;
    }

    @ManagedAttribute(description="Source")
    public String getSource() {
        if (this.consumerCache.getSource() != null) {
            return this.consumerCache.getSource().toString();
        }
        return null;
    }

    @ManagedAttribute(description="Number of elements cached")
    public Integer getSize() {
        return this.consumerCache.size();
    }

    @ManagedAttribute(description="Maximum cache size (capacity)")
    public Integer getMaximumCacheSize() {
        return this.consumerCache.getCapacity();
    }

    @ManagedAttribute(description="Cache hits")
    public Long getHits() {
        return this.consumerCache.getHits();
    }

    @ManagedAttribute(description="Cache misses")
    public Long getMisses() {
        return this.consumerCache.getMisses();
    }

    @ManagedOperation(description="Reset cache statistics")
    public void resetStatistics() {
        this.consumerCache.resetCacheStatistics();
    }

    @ManagedOperation(description="Purges the cache")
    public void purge() {
        this.consumerCache.purge();
    }
}

