/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.management.mbean.Statistic;
import org.apache.camel.spi.ManagementStrategy;

@ManagedResource(description="Managed Counter")
public abstract class ManagedCounter {
    protected Statistic exchangesTotal;

    public void init(ManagementStrategy strategy) {
        this.exchangesTotal = new Statistic("org.apache.camel.exchangesTotal", this, Statistic.UpdateMode.COUNTER);
    }

    @ManagedOperation(description="Reset counters")
    public synchronized void reset() {
        this.exchangesTotal.reset();
    }

    @ManagedAttribute(description="Total number of exchanges")
    public long getExchangesTotal() throws Exception {
        return this.exchangesTotal.getValue();
    }

    public synchronized void increment() {
        this.exchangesTotal.increment();
    }
}

