/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.Delayer;

@ManagedResource(description="Managed Delayer")
public class ManagedDelayer
extends ManagedProcessor {
    private final Delayer delayer;

    public ManagedDelayer(CamelContext context, Delayer delayer, ProcessorDefinition<?> definition) {
        super(context, delayer, definition);
        this.delayer = delayer;
    }

    public Delayer getDelayer() {
        return this.delayer;
    }

    @ManagedAttribute(description="Delay")
    public Long getDelay() {
        return this.getDelayer().getDelayValue();
    }

    @ManagedOperation(description="Set a constant delay in millis")
    public void constantDelay(Integer millis) {
        Expression delay = ExpressionBuilder.constantExpression(millis);
        this.getDelayer().setDelay(delay);
    }
}

