/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.Endpoint;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StatefulService;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedInstance;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.spi.ManagementStrategy;

@ManagedResource(description="Managed Endpoint")
public class ManagedEndpoint
implements ManagedInstance {
    private final Endpoint endpoint;

    public ManagedEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void init(ManagementStrategy strategy) {
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @ManagedAttribute(description="Camel id")
    public String getCamelId() {
        return this.endpoint.getCamelContext().getName();
    }

    @ManagedAttribute(description="Endpoint Uri")
    public String getEndpointUri() {
        return this.endpoint.getEndpointUri();
    }

    @ManagedAttribute(description="Singleton")
    public boolean isSingleton() {
        return this.endpoint.isSingleton();
    }

    @ManagedAttribute(description="Service State")
    public String getState() {
        if (this.endpoint instanceof StatefulService) {
            ServiceStatus status = ((StatefulService)((Object)this.endpoint)).getStatus();
            if (status == null) {
                status = ServiceStatus.Stopped;
            }
            return status.name();
        }
        return ServiceStatus.Started.name();
    }

    @Override
    public Object getInstance() {
        return this.endpoint;
    }
}

