/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.impl.EndpointRegistry;
import org.apache.camel.management.mbean.ManagedService;

@ManagedResource(description="Managed EndpointRegistry")
public class ManagedEndpointRegistry
extends ManagedService {
    private final EndpointRegistry endpointRegistry;

    public ManagedEndpointRegistry(CamelContext context, EndpointRegistry endpointRegistry) {
        super(context, endpointRegistry);
        this.endpointRegistry = endpointRegistry;
    }

    public EndpointRegistry getEndpointRegistry() {
        return this.endpointRegistry;
    }

    @ManagedAttribute(description="Source")
    public String getSource() {
        return this.endpointRegistry.toString();
    }

    @ManagedAttribute(description="Number of endpoints cached")
    public Integer getSize() {
        return this.endpointRegistry.size();
    }

    @ManagedAttribute(description="Maximum cache size (capacity)")
    public Integer getMaximumCacheSize() {
        return this.endpointRegistry.getMaxCacheSize();
    }

    @ManagedOperation(description="Purges the cache")
    public void purge() {
        this.endpointRegistry.purge();
    }
}

