/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Date;
import org.apache.camel.Exchange;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.PerformanceCounter;
import org.apache.camel.management.mbean.ManagedCounter;
import org.apache.camel.management.mbean.Statistic;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.util.ExchangeHelper;

@ManagedResource(description="PerformanceCounter")
public abstract class ManagedPerformanceCounter
extends ManagedCounter
implements PerformanceCounter {
    private Statistic exchangesCompleted;
    private Statistic exchangesFailed;
    private Statistic failuresHandled;
    private Statistic redeliveries;
    private Statistic minProcessingTime;
    private Statistic maxProcessingTime;
    private Statistic totalProcessingTime;
    private Statistic lastProcessingTime;
    private Statistic meanProcessingTime;
    private Statistic firstExchangeCompletedTimestamp;
    private Statistic firstExchangeFailureTimestamp;
    private Statistic lastExchangeCompletedTimestamp;
    private Statistic lastExchangeFailureTimestamp;
    private boolean statisticsEnabled = true;

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
        this.exchangesCompleted = new Statistic("org.apache.camel.exchangesCompleted", this, Statistic.UpdateMode.COUNTER);
        this.exchangesFailed = new Statistic("org.apache.camel.exchangesFailed", this, Statistic.UpdateMode.COUNTER);
        this.failuresHandled = new Statistic("org.apache.camel.failuresHandled", this, Statistic.UpdateMode.COUNTER);
        this.redeliveries = new Statistic("org.apache.camel.redeliveries", this, Statistic.UpdateMode.COUNTER);
        this.minProcessingTime = new Statistic("org.apache.camel.minimumProcessingTime", this, Statistic.UpdateMode.MINIMUM);
        this.maxProcessingTime = new Statistic("org.apache.camel.maximumProcessingTime", this, Statistic.UpdateMode.MAXIMUM);
        this.totalProcessingTime = new Statistic("org.apache.camel.totalProcessingTime", this, Statistic.UpdateMode.COUNTER);
        this.lastProcessingTime = new Statistic("org.apache.camel.lastProcessingTime", this, Statistic.UpdateMode.VALUE);
        this.meanProcessingTime = new Statistic("org.apache.camel.meanProcessingTime", this, Statistic.UpdateMode.VALUE);
        this.firstExchangeCompletedTimestamp = new Statistic("org.apache.camel.firstExchangeCompletedTimestamp", this, Statistic.UpdateMode.VALUE);
        this.firstExchangeFailureTimestamp = new Statistic("org.apache.camel.firstExchangeFailureTimestamp", this, Statistic.UpdateMode.VALUE);
        this.lastExchangeCompletedTimestamp = new Statistic("org.apache.camel.lastExchangeCompletedTimestamp", this, Statistic.UpdateMode.VALUE);
        this.lastExchangeFailureTimestamp = new Statistic("org.apache.camel.lastExchangeFailureTimestamp", this, Statistic.UpdateMode.VALUE);
    }

    @Override
    @ManagedOperation(description="Reset counters")
    public synchronized void reset() {
        super.reset();
        this.exchangesCompleted.reset();
        this.exchangesFailed.reset();
        this.failuresHandled.reset();
        this.redeliveries.reset();
        this.minProcessingTime.reset();
        this.maxProcessingTime.reset();
        this.totalProcessingTime.reset();
        this.lastProcessingTime.reset();
        this.meanProcessingTime.reset();
        this.firstExchangeCompletedTimestamp.reset();
        this.firstExchangeFailureTimestamp.reset();
        this.lastExchangeCompletedTimestamp.reset();
        this.lastExchangeFailureTimestamp.reset();
    }

    @ManagedAttribute(description="Number of completed exchanges")
    public long getExchangesCompleted() throws Exception {
        return this.exchangesCompleted.getValue();
    }

    @ManagedAttribute(description="Number of failed exchanges")
    public long getExchangesFailed() throws Exception {
        return this.exchangesFailed.getValue();
    }

    @ManagedAttribute(description="Number of failures handled")
    public long getFailuresHandled() throws Exception {
        return this.failuresHandled.getValue();
    }

    @ManagedAttribute(description="Number of redeliveries")
    public long getRedeliveries() throws Exception {
        return this.redeliveries.getValue();
    }

    @ManagedAttribute(description="Min Processing Time [milliseconds]")
    public long getMinProcessingTime() throws Exception {
        return this.minProcessingTime.getValue();
    }

    @ManagedAttribute(description="Mean Processing Time [milliseconds]")
    public long getMeanProcessingTime() throws Exception {
        return this.meanProcessingTime.getValue();
    }

    @ManagedAttribute(description="Max Processing Time [milliseconds]")
    public long getMaxProcessingTime() throws Exception {
        return this.maxProcessingTime.getValue();
    }

    @ManagedAttribute(description="Total Processing Time [milliseconds]")
    public long getTotalProcessingTime() throws Exception {
        return this.totalProcessingTime.getValue();
    }

    @ManagedAttribute(description="Last Processing Time [milliseconds]")
    public long getLastProcessingTime() throws Exception {
        return this.lastProcessingTime.getValue();
    }

    @ManagedAttribute(description="Last Exchange Completed Timestamp")
    public Date getLastExchangeCompletedTimestamp() {
        long value = this.lastExchangeCompletedTimestamp.getValue();
        return value > 0L ? new Date(value) : null;
    }

    @ManagedAttribute(description="First Exchange Completed Timestamp")
    public Date getFirstExchangeCompletedTimestamp() {
        long value = this.firstExchangeCompletedTimestamp.getValue();
        return value > 0L ? new Date(value) : null;
    }

    @ManagedAttribute(description="Last Exchange Failed Timestamp")
    public Date getLastExchangeFailureTimestamp() {
        long value = this.lastExchangeFailureTimestamp.getValue();
        return value > 0L ? new Date(value) : null;
    }

    @ManagedAttribute(description="First Exchange Failed Timestamp")
    public Date getFirstExchangeFailureTimestamp() {
        long value = this.firstExchangeFailureTimestamp.getValue();
        return value > 0L ? new Date(value) : null;
    }

    @Override
    @ManagedAttribute(description="Statistics enabled")
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Override
    @ManagedAttribute(description="Statistics enabled")
    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    @Override
    public synchronized void completedExchange(Exchange exchange, long time) {
        this.increment();
        this.exchangesCompleted.increment();
        if (ExchangeHelper.isFailureHandled(exchange)) {
            this.failuresHandled.increment();
        }
        this.minProcessingTime.updateValue(time);
        this.maxProcessingTime.updateValue(time);
        this.totalProcessingTime.updateValue(time);
        this.lastProcessingTime.updateValue(time);
        long now = new Date().getTime();
        if (this.firstExchangeCompletedTimestamp.getUpdateCount() == 0L) {
            this.firstExchangeCompletedTimestamp.updateValue(now);
        }
        this.lastExchangeCompletedTimestamp.updateValue(now);
        long count = this.exchangesCompleted.getValue();
        long mean = count > 0L ? this.totalProcessingTime.getValue() / count : 0L;
        this.meanProcessingTime.updateValue(mean);
    }

    @Override
    public synchronized void failedExchange(Exchange exchange) {
        this.increment();
        this.exchangesFailed.increment();
        if (ExchangeHelper.isRedelivered(exchange)) {
            this.redeliveries.increment();
        }
        long now = new Date().getTime();
        if (this.firstExchangeFailureTimestamp.getUpdateCount() == 0L) {
            this.firstExchangeFailureTimestamp.updateValue(now);
        }
        this.lastExchangeFailureTimestamp.updateValue(now);
    }
}

