/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.TimerListener;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.management.mbean.LoadTriplet;
import org.apache.camel.management.mbean.ManagedPerformanceCounter;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ModelHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.util.ObjectHelper;

@ManagedResource(description="Managed Route")
public class ManagedRoute
extends ManagedPerformanceCounter
implements TimerListener {
    public static final String VALUE_UNKNOWN = "Unknown";
    protected final Route route;
    protected final String description;
    protected final ModelCamelContext context;
    private final LoadTriplet load = new LoadTriplet();

    public ManagedRoute(ModelCamelContext context, Route route) {
        this.route = route;
        this.context = context;
        this.description = route.toString();
        boolean enabled = context.getManagementStrategy().getStatisticsLevel() != ManagementStatisticsLevel.Off;
        this.setStatisticsEnabled(enabled);
    }

    public Route getRoute() {
        return this.route;
    }

    public CamelContext getContext() {
        return this.context;
    }

    @ManagedAttribute(description="Route id")
    public String getRouteId() {
        String id = this.route.getId();
        if (id == null) {
            id = VALUE_UNKNOWN;
        }
        return id;
    }

    @ManagedAttribute(description="Route Description")
    public String getDescription() {
        return this.description;
    }

    @ManagedAttribute(description="Route Endpoint Uri")
    public String getEndpointUri() {
        Endpoint ep = this.route.getEndpoint();
        return ep != null ? ep.getEndpointUri() : VALUE_UNKNOWN;
    }

    @ManagedAttribute(description="Route State")
    public String getState() {
        ServiceStatus status = this.context.getRouteStatus(this.route.getId());
        if (status == null) {
            status = ServiceStatus.Stopped;
        }
        return status.name();
    }

    @ManagedAttribute(description="Current number of inflight Exchanges")
    public Integer getInflightExchanges() {
        if (this.route.getEndpoint() != null) {
            return this.context.getInflightRepository().size(this.route.getEndpoint());
        }
        return null;
    }

    @ManagedAttribute(description="Camel id")
    public String getCamelId() {
        return this.context.getName();
    }

    @ManagedAttribute(description="Tracing")
    public Boolean getTracing() {
        return this.route.getRouteContext().isTracing();
    }

    @ManagedAttribute(description="Tracing")
    public void setTracing(Boolean tracing) {
        this.route.getRouteContext().setTracing(tracing);
    }

    @ManagedAttribute(description="Route Policy List")
    public String getRoutePolicyList() {
        List<RoutePolicy> policyList = this.route.getRouteContext().getRoutePolicyList();
        if (policyList == null || policyList.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < policyList.size(); ++i) {
            RoutePolicy policy = policyList.get(i);
            sb.append(policy.getClass().getSimpleName());
            sb.append("(").append(ObjectHelper.getIdentityHashCode(policy)).append(")");
            if (i >= policyList.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @ManagedAttribute(description="Average load over the last minute")
    public String getLoad01() {
        return String.format("%.2f", this.load.getLoad1());
    }

    @ManagedAttribute(description="Average load over the last five minutes")
    public String getLoad05() {
        return String.format("%.2f", this.load.getLoad5());
    }

    @ManagedAttribute(description="Average load over the last fifteen minutes")
    public String getLoad15() {
        return String.format("%.2f", this.load.getLoad15());
    }

    @Override
    public void onTimer() {
        this.load.update(this.getInflightExchanges());
    }

    @ManagedOperation(description="Start route")
    public void start() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.context.startRoute(this.getRouteId());
    }

    @ManagedOperation(description="Stop route")
    public void stop() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.context.stopRoute(this.getRouteId());
    }

    @ManagedOperation(description="Stop route (using timeout in seconds)")
    public void stop(long timeout) throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.context.stopRoute(this.getRouteId(), timeout, TimeUnit.SECONDS);
    }

    @ManagedOperation(description="Stop route, abort stop after timeout (in seconds)")
    public boolean stop(Long timeout, Boolean abortAfterTimeout) throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        return this.context.stopRoute(this.getRouteId(), timeout, TimeUnit.SECONDS, abortAfterTimeout);
    }

    @ManagedOperation(description="Shutdown and remove route")
    @Deprecated
    public void shutdown() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.context.shutdownRoute(this.getRouteId());
    }

    @ManagedOperation(description="Shutdown and remove route (using timeout in seconds)")
    @Deprecated
    public void shutdown(long timeout) throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.context.shutdownRoute(this.getRouteId(), timeout, TimeUnit.SECONDS);
    }

    @ManagedOperation(description="Remove route (must be stopped)")
    public boolean remove() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        return this.context.removeRoute(this.getRouteId());
    }

    @ManagedOperation(description="Dumps the route as XML")
    public String dumpRouteAsXml() throws Exception {
        String id = this.route.getId();
        RouteDefinition def = this.context.getRouteDefinition(id);
        if (def != null) {
            return ModelHelper.dumpModelAsXml(def);
        }
        return null;
    }

    @ManagedOperation(description="Updates the route from XML")
    public void updateRouteFromXml(String xml) throws Exception {
        RouteDefinition def = ModelHelper.createModelFromXml(xml, RouteDefinition.class);
        if (def == null) {
            return;
        }
        this.context.addRouteDefinition(def);
    }
}

