/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.impl.ThrottlingInflightRoutePolicy;
import org.apache.camel.management.mbean.ManagedService;

@ManagedResource(description="Managed ThrottlingInflightRoutePolicy")
public class ManagedThrottlingInflightRoutePolicy
extends ManagedService {
    private final ThrottlingInflightRoutePolicy policy;

    public ManagedThrottlingInflightRoutePolicy(CamelContext context, ThrottlingInflightRoutePolicy policy) {
        super(context, policy);
        this.policy = policy;
    }

    public ThrottlingInflightRoutePolicy getPolicy() {
        return this.policy;
    }

    @ManagedAttribute(description="Maximum inflight exchanges")
    public int getMaxInflightExchanges() {
        return this.getPolicy().getMaxInflightExchanges();
    }

    @ManagedAttribute(description="Maximum inflight exchanges")
    public void setMaxInflightExchanges(int maxInflightExchanges) {
        this.getPolicy().setMaxInflightExchanges(maxInflightExchanges);
    }

    @ManagedAttribute(description="Resume percentage of maximum inflight exchanges")
    public int getResumePercentOfMax() {
        return this.getPolicy().getResumePercentOfMax();
    }

    @ManagedAttribute(description="Resume percentage of maximum inflight exchanges")
    public void setResumePercentOfMax(int resumePercentOfMax) {
        this.getPolicy().setResumePercentOfMax(resumePercentOfMax);
    }

    @ManagedAttribute(description="Scope")
    public String getScope() {
        return this.getPolicy().getScope().name();
    }

    @ManagedAttribute(description="Scope")
    public void setScope(String scope) {
        this.getPolicy().setScope(ThrottlingInflightRoutePolicy.ThrottlingScope.valueOf(scope));
    }

    @ManagedAttribute(description="Logging Level")
    public String getLoggingLevel() {
        return this.getPolicy().getLoggingLevel().name();
    }

    @ManagedAttribute(description="Logging Level")
    public void setLoggingLevel(String loggingLevel) {
        LoggingLevel level = LoggingLevel.valueOf(loggingLevel);
        this.getPolicy().setLoggingLevel(level);
        this.getPolicy().getLogger().setLevel(level);
    }
}

