/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.language;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.Predicate;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.MethodNotFoundException;
import org.apache.camel.component.bean.RegistryBean;
import org.apache.camel.language.bean.BeanExpression;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OgnlHelper;

@XmlRootElement(name="method")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MethodCallExpression
extends ExpressionDefinition {
    @XmlAttribute
    @Deprecated
    private String bean;
    @XmlAttribute
    private String ref;
    @XmlAttribute
    private String method;
    @XmlAttribute(name="beanType")
    private String beanTypeName;
    @XmlTransient
    private Class<?> beanType;
    @XmlTransient
    private Object instance;

    public MethodCallExpression() {
    }

    public MethodCallExpression(String beanName) {
        this(beanName, null);
    }

    public MethodCallExpression(String beanName, String method) {
        super(beanName);
        this.method = method;
    }

    public MethodCallExpression(Object instance) {
        this(instance, null);
    }

    public MethodCallExpression(Object instance, String method) {
        super(instance.getClass().getName());
        this.instance = instance;
        this.method = method;
    }

    public MethodCallExpression(Class<?> type) {
        this(type, null);
    }

    public MethodCallExpression(Class<?> type, String method) {
        super(type.toString());
        this.beanType = type;
        this.method = method;
    }

    @Override
    public String getLanguage() {
        return "bean";
    }

    public String getBean() {
        return this.bean;
    }

    public void setBean(String bean) {
        this.bean = bean;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Class<?> getBeanType() {
        return this.beanType;
    }

    public void setBeanType(Class<?> beanType) {
        this.beanType = beanType;
    }

    public String getBeanTypeName() {
        return this.beanTypeName;
    }

    public void setBeanTypeName(String beanTypeName) {
        this.beanTypeName = beanTypeName;
    }

    public Object getInstance() {
        return this.instance;
    }

    public void setInstance(Object instance) {
        this.instance = instance;
    }

    @Override
    public Expression createExpression(CamelContext camelContext) {
        BeanExpression answer;
        if (this.beanType == null && this.beanTypeName != null) {
            try {
                this.beanType = camelContext.getClassResolver().resolveMandatoryClass(this.beanTypeName);
            }
            catch (ClassNotFoundException e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        if (this.beanType != null) {
            if (ObjectHelper.hasDefaultPublicNoArgConstructor(this.beanType)) {
                this.instance = camelContext.getInjector().newInstance(this.beanType);
                answer = new BeanExpression(this.instance, this.getMethod());
            } else {
                answer = new BeanExpression(this.beanType, this.getMethod());
            }
        } else if (this.instance != null) {
            answer = new BeanExpression(this.instance, this.getMethod());
        } else {
            String ref = this.beanName();
            RegistryBean holder = new RegistryBean(camelContext, ref);
            this.instance = holder.getBean();
            answer = new BeanExpression(this.instance, this.getMethod());
        }
        this.validateHasMethod(camelContext, this.instance, this.beanType, this.getMethod());
        return answer;
    }

    @Override
    public Predicate createPredicate(CamelContext camelContext) {
        return (BeanExpression)this.createExpression(camelContext);
    }

    protected void validateHasMethod(CamelContext context, Object bean, Class<?> type, String method) {
        if (method == null) {
            return;
        }
        if (bean == null && type == null) {
            throw new IllegalArgumentException("Either bean or type should be provided on " + this);
        }
        if (OgnlHelper.isValidOgnlExpression(method)) {
            return;
        }
        if (OgnlHelper.isInvalidValidOgnlExpression(method)) {
            ExpressionIllegalSyntaxException cause = new ExpressionIllegalSyntaxException(method);
            throw ObjectHelper.wrapRuntimeCamelException(new MethodNotFoundException((Object)(bean != null ? bean : type), method, (Throwable)cause));
        }
        if (bean != null) {
            BeanInfo info = new BeanInfo(context, bean.getClass());
            if (!info.hasMethod(method)) {
                throw ObjectHelper.wrapRuntimeCamelException(new MethodNotFoundException(null, bean, method));
            }
        } else {
            BeanInfo info = new BeanInfo(context, type);
            if (!info.hasStaticMethod(method)) {
                throw ObjectHelper.wrapRuntimeCamelException(new MethodNotFoundException(null, type, method, true));
            }
        }
    }

    protected String beanName() {
        if (this.bean != null) {
            return this.bean;
        }
        if (this.ref != null) {
            return this.ref;
        }
        if (this.instance != null) {
            return ObjectHelper.className(this.instance);
        }
        return this.getExpression();
    }

    @Override
    public String toString() {
        return "bean{" + this.beanName() + (this.method != null ? ", method=" + this.method : "") + "}";
    }
}

