/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.language;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.language.tokenizer.TokenizeLanguage;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.util.ExpressionToPredicateAdapter;

@XmlRootElement(name="tokenize")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TokenizerExpression
extends ExpressionDefinition {
    @XmlAttribute(required=true)
    private String token;
    @XmlAttribute
    private String endToken;
    @XmlAttribute
    private String headerName;
    @XmlAttribute
    private Boolean regex;

    @Override
    public String getLanguage() {
        return "tokenize";
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getEndToken() {
        return this.endToken;
    }

    public void setEndToken(String endToken) {
        this.endToken = endToken;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public void setRegex(boolean regex) {
        this.regex = regex;
    }

    public Boolean getRegex() {
        return this.regex;
    }

    @Override
    public Expression createExpression(CamelContext camelContext) {
        TokenizeLanguage language = new TokenizeLanguage();
        language.setToken(this.token);
        language.setEndToken(this.endToken);
        language.setHeaderName(this.headerName);
        if (this.regex != null) {
            language.setRegex(this.regex);
        }
        return language.createExpression();
    }

    @Override
    public Predicate createPredicate(CamelContext camelContext) {
        Expression exp = this.createExpression(camelContext);
        return ExpressionToPredicateAdapter.toPredicate(exp);
    }

    @Override
    public String toString() {
        if (this.endToken != null) {
            return "tokenize{body() using tokens: " + this.token + "..." + this.endToken + "}";
        }
        return "tokenize{" + (this.headerName != null ? "header: " + this.headerName : "body()") + " using token: " + this.token + "}";
    }
}

