/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.util.CamelLogger;

public class CamelLogProcessor
implements Processor {
    private CamelLogger log;
    private ExchangeFormatter formatter = new DefaultExchangeFormatter();

    public CamelLogProcessor() {
        this(new CamelLogger(CamelLogProcessor.class.getName()));
    }

    public CamelLogProcessor(CamelLogger log) {
        this.log = log;
    }

    public CamelLogProcessor(CamelLogger log, ExchangeFormatter formatter) {
        this(log);
        this.formatter = formatter;
    }

    public String toString() {
        return "Logger[" + this.log + "]";
    }

    @Override
    public void process(Exchange exchange) {
        if (this.log.shouldLog()) {
            this.log.log(this.formatter.format(exchange));
        }
    }

    public void process(Exchange exchange, Throwable exception) {
        if (this.log.shouldLog()) {
            this.log.log(this.formatter.format(exchange), exception);
        }
    }

    public void process(Exchange exchange, String message) {
        if (this.log.shouldLog()) {
            this.log.log(this.formatter.format(exchange) + message);
        }
    }

    public CamelLogger getLogger() {
        return this.log;
    }

    public void setLogName(String logName) {
        this.log.setLogName(logName);
    }

    public void setLevel(LoggingLevel level) {
        this.log.setLevel(level);
    }

    static class DefaultExchangeFormatter
    implements ExchangeFormatter {
        DefaultExchangeFormatter() {
        }

        @Override
        public String format(Exchange exchange) {
            return exchange.toString();
        }
    }
}

