/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Scanner;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

public class TokenPairExpressionIterator
extends ExpressionAdapter {
    private final String startToken;
    private final String endToken;

    public TokenPairExpressionIterator(String startToken, String endToken) {
        this.startToken = startToken;
        this.endToken = endToken;
        ObjectHelper.notEmpty(startToken, "startToken");
        ObjectHelper.notEmpty(endToken, "endToken");
    }

    @Override
    public Object evaluate(Exchange exchange) {
        try {
            InputStream in = exchange.getIn().getMandatoryBody(InputStream.class);
            String charset = IOHelper.getCharsetName(exchange);
            return new TokenPairIterator(this.startToken, this.endToken, in, charset);
        }
        catch (InvalidPayloadException e) {
            exchange.setException(e);
            return null;
        }
    }

    public String toString() {
        return "tokenize[body() using tokens: " + this.startToken + "..." + this.endToken + "]";
    }

    private static final class TokenPairIterator
    implements Iterator,
    Closeable {
        private final String startToken;
        private final String endToken;
        private final Scanner scanner;
        private Object image;

        private TokenPairIterator(String startToken, String endToken, InputStream in, String charset) {
            this.startToken = startToken;
            this.endToken = endToken;
            this.scanner = new Scanner(in, charset).useDelimiter(endToken);
            this.image = this.scanner.hasNext() ? this.next() : null;
        }

        @Override
        public boolean hasNext() {
            return this.image != null;
        }

        public Object next() {
            Object answer = this.image;
            this.image = this.scanner.hasNext() ? this.getNext() : null;
            if (answer == null) {
                answer = this.image;
            }
            return answer;
        }

        private Object getNext() {
            String next = this.scanner.next();
            if (next != null && next.contains(this.startToken)) {
                if ((next = ObjectHelper.after(next, this.startToken)) != null) {
                    StringBuilder sb = new StringBuilder();
                    next = sb.append(this.startToken).append(next).append(this.endToken).toString();
                }
            } else {
                return null;
            }
            return next;
        }

        @Override
        public void remove() {
        }

        @Override
        public void close() throws IOException {
            this.scanner.close();
        }
    }
}

