/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import org.apache.camel.LoggingLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelLogger {
    private Logger log;
    private LoggingLevel level;

    public CamelLogger() {
        this(LoggerFactory.getLogger(CamelLogger.class));
    }

    public CamelLogger(Logger log) {
        this(log, LoggingLevel.INFO);
    }

    public CamelLogger(Logger log, LoggingLevel level) {
        this.log = log;
        this.setLevel(level);
    }

    public CamelLogger(String logName) {
        this(LoggerFactory.getLogger((String)logName));
    }

    public CamelLogger(String logName, LoggingLevel level) {
        this(LoggerFactory.getLogger((String)logName), level);
    }

    public String toString() {
        return "Logger[" + this.log + "]";
    }

    public void log(String message, LoggingLevel loggingLevel) {
        LoggingLevel oldLogLevel = this.getLevel();
        this.setLevel(loggingLevel);
        this.log(message);
        this.setLevel(oldLogLevel);
    }

    public void log(String message) {
        if (CamelLogger.shouldLog(this.log, this.level)) {
            CamelLogger.log(this.log, this.level, message);
        }
    }

    public void log(String message, Throwable exception, LoggingLevel loggingLevel) {
        CamelLogger.log(this.log, loggingLevel, message, exception);
    }

    public void log(String message, Throwable exception) {
        if (CamelLogger.shouldLog(this.log, this.level)) {
            CamelLogger.log(this.log, this.level, message, exception);
        }
    }

    public Logger getLog() {
        return this.log;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public LoggingLevel getLevel() {
        return this.level;
    }

    public void setLevel(LoggingLevel level) {
        if (level == null) {
            throw new IllegalArgumentException("Log level may not be null");
        }
        this.level = level;
    }

    public void setLogName(String logName) {
        this.log = LoggerFactory.getLogger((String)logName);
    }

    public static void log(Logger log, LoggingLevel level, String message) {
        switch (level) {
            case DEBUG: {
                log.debug(message);
                break;
            }
            case ERROR: {
                log.error(message);
                break;
            }
            case INFO: {
                log.info(message);
                break;
            }
            case TRACE: {
                log.trace(message);
                break;
            }
            case WARN: {
                log.warn(message);
                break;
            }
        }
    }

    public static void log(Logger log, LoggingLevel level, String message, Throwable th) {
        switch (level) {
            case DEBUG: {
                log.debug(message, th);
                break;
            }
            case ERROR: {
                log.error(message, th);
                break;
            }
            case INFO: {
                log.info(message, th);
                break;
            }
            case TRACE: {
                log.trace(message, th);
                break;
            }
            case WARN: {
                log.warn(message, th);
                break;
            }
        }
    }

    public boolean shouldLog() {
        return CamelLogger.shouldLog(this.log, this.level);
    }

    public static boolean shouldLog(Logger log, LoggingLevel level) {
        switch (level) {
            case DEBUG: {
                return log.isDebugEnabled();
            }
            case ERROR: {
                return log.isErrorEnabled();
            }
            case INFO: {
                return log.isInfoEnabled();
            }
            case TRACE: {
                return log.isTraceEnabled();
            }
            case WARN: {
                return log.isWarnEnabled();
            }
        }
        return false;
    }
}

