/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.ObjectHelper;

public final class ResourceHelper {
    private ResourceHelper() {
    }

    public static InputStream resolveMandatoryResourceAsInputStream(ClassResolver classResolver, String uri) throws IOException {
        InputStream is;
        if (uri.startsWith("file:")) {
            uri = ObjectHelper.after(uri, "file:");
            return new FileInputStream(uri);
        }
        if (uri.startsWith("http:")) {
            URL url = new URL(uri);
            URLConnection con = url.openConnection();
            con.setUseCaches(false);
            try {
                return con.getInputStream();
            }
            catch (IOException e) {
                if (con instanceof HttpURLConnection) {
                    ((HttpURLConnection)con).disconnect();
                }
                throw e;
            }
        }
        if (uri.startsWith("classpath:")) {
            uri = ObjectHelper.after(uri, "classpath:");
        }
        if ((is = classResolver.loadResourceAsStream(uri)) == null) {
            throw new FileNotFoundException("Cannot find resource in classpath for URI: " + uri);
        }
        return is;
    }

    public static URL resolveMandatoryResourceAsUrl(ClassResolver classResolver, String uri) throws FileNotFoundException, MalformedURLException {
        URL url;
        if (uri.startsWith("file:")) {
            String name = ObjectHelper.after(uri, "file:");
            File file = new File(name);
            if (!file.exists()) {
                throw new FileNotFoundException("File " + file + " not found");
            }
            return new URL(uri);
        }
        if (uri.startsWith("http:")) {
            return new URL(uri);
        }
        if (uri.startsWith("classpath:")) {
            uri = ObjectHelper.after(uri, "classpath:");
        }
        if ((url = classResolver.loadResourceAsURL(uri)) == null) {
            throw new FileNotFoundException("Cannot find resource in classpath for URI: " + uri);
        }
        return url;
    }
}

