/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Service;
import org.apache.camel.component.cxf.NullFaultListener;
import org.apache.camel.component.cxf.jaxrs.CamelResourceProvider;
import org.apache.camel.component.cxf.jaxrs.CxfRsBinding;
import org.apache.camel.component.cxf.jaxrs.CxfRsConsumer;
import org.apache.camel.component.cxf.jaxrs.CxfRsHeaderFilterStrategy;
import org.apache.camel.component.cxf.jaxrs.CxfRsProducer;
import org.apache.camel.component.cxf.jaxrs.DefaultCxfRsBinding;
import org.apache.camel.component.cxf.jaxrs.SimpleCxfRsBinding;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.feature.LoggingFeature;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.logging.FaultListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CxfRsEndpoint
extends DefaultEndpoint
implements HeaderFilterStrategyAware,
Service {
    private static final Logger LOG = LoggerFactory.getLogger(CxfRsEndpoint.class);
    protected Bus bus;
    protected List<Object> entityProviders = new LinkedList<Object>();
    protected List<String> schemaLocations;
    private Map<String, String> parameters;
    private List<Class<?>> resourceClasses;
    private HeaderFilterStrategy headerFilterStrategy;
    private CxfRsBinding binding;
    private boolean httpClientAPI = true;
    private String address;
    private boolean throwExceptionOnFailure = true;
    private int maxClientCacheSize = 10;
    private boolean loggingFeatureEnabled;
    private int loggingSizeLimit;
    private boolean skipFaultLogging;
    private BindingStyle bindingStyle = BindingStyle.Default;
    private boolean isSetDefaultBus;

    @Deprecated
    public CxfRsEndpoint(String endpointUri, CamelContext camelContext) {
        super(endpointUri, camelContext);
        this.setAddress(endpointUri);
    }

    public CxfRsEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
        this.setAddress(endpointUri);
    }

    protected void updateEndpointUri(String endpointUri) {
        super.setEndpointUri(endpointUri);
    }

    public void setParameters(Map<String, String> param) {
        this.parameters = param;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setHttpClientAPI(boolean clientAPI) {
        this.httpClientAPI = clientAPI;
    }

    public boolean isHttpClientAPI() {
        return this.httpClientAPI;
    }

    public boolean isLenientProperties() {
        return true;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        CxfRsConsumer answer = new CxfRsConsumer(this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public Producer createProducer() throws Exception {
        if (this.bindingStyle == BindingStyle.SimpleConsumer) {
            throw new IllegalArgumentException("The SimpleConsumer Binding Style cannot be used in a camel-cxfrs producer");
        }
        return new CxfRsProducer(this);
    }

    public boolean isSingleton() {
        return false;
    }

    public void setBinding(CxfRsBinding binding) {
        this.binding = binding;
    }

    public CxfRsBinding getBinding() {
        return this.binding;
    }

    public boolean isSkipFaultLogging() {
        return this.skipFaultLogging;
    }

    public void setSkipFaultLogging(boolean skipFaultLogging) {
        this.skipFaultLogging = skipFaultLogging;
    }

    protected void checkBeanType(Object object, Class<?> clazz) {
        if (!clazz.isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException("The configure bean is not the instance of " + clazz.getName());
        }
    }

    protected void setupJAXRSServerFactoryBean(JAXRSServerFactoryBean sfb) {
        if (this.getAddress() != null) {
            sfb.setAddress(this.getAddress());
        }
        if (this.getResourceClasses() != null) {
            List<Class<?>> res = this.getResourceClasses();
            for (Class<?> clazz : res) {
                sfb.setResourceProvider(clazz, (ResourceProvider)new CamelResourceProvider(clazz));
            }
            sfb.setResourceClasses(res);
        }
        sfb.setStart(false);
    }

    protected void setupJAXRSClientFactoryBean(JAXRSClientFactoryBean cfb, String address) {
        if (address != null) {
            cfb.setAddress(address);
        }
        if (this.getResourceClasses() != null && !this.getResourceClasses().isEmpty()) {
            cfb.setResourceClass(this.getResourceClasses().get(0));
            cfb.getServiceFactory().setResourceClasses(this.getResourceClasses());
        }
        if (this.isLoggingFeatureEnabled()) {
            if (this.getLoggingSizeLimit() > 0) {
                cfb.getFeatures().add(new LoggingFeature(this.getLoggingSizeLimit()));
            } else {
                cfb.getFeatures().add(new LoggingFeature());
            }
        }
        if (this.isSkipFaultLogging()) {
            if (cfb.getProperties() == null) {
                cfb.setProperties(new HashMap());
            }
            cfb.getProperties().put(FaultListener.class.getName(), new NullFaultListener());
        }
        cfb.setThreadSafe(true);
    }

    protected JAXRSServerFactoryBean newJAXRSServerFactoryBean() {
        return new JAXRSServerFactoryBean();
    }

    protected JAXRSClientFactoryBean newJAXRSClientFactoryBean() {
        return new JAXRSClientFactoryBean();
    }

    protected String resolvePropertyPlaceholders(String str) {
        try {
            if (this.getCamelContext() != null) {
                return this.getCamelContext().resolvePropertyPlaceholders(str);
            }
            return str;
        }
        catch (Exception ex) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)ex);
        }
    }

    public JAXRSServerFactoryBean createJAXRSServerFactoryBean() {
        JAXRSServerFactoryBean answer = this.newJAXRSServerFactoryBean();
        this.setupJAXRSServerFactoryBean(answer);
        if (!this.getProviders().isEmpty()) {
            answer.setProviders(this.getProviders());
        }
        if (this.schemaLocations != null) {
            answer.setSchemaLocations(this.schemaLocations);
        }
        if (this.isLoggingFeatureEnabled()) {
            if (this.getLoggingSizeLimit() > 0) {
                answer.getFeatures().add(new LoggingFeature(this.getLoggingSizeLimit()));
            } else {
                answer.getFeatures().add(new LoggingFeature());
            }
        }
        if (this.isSkipFaultLogging()) {
            if (answer.getProperties() == null) {
                answer.setProperties(new HashMap());
            }
            answer.getProperties().put(FaultListener.class.getName(), new NullFaultListener());
        }
        return answer;
    }

    public JAXRSClientFactoryBean createJAXRSClientFactoryBean() {
        return this.createJAXRSClientFactoryBean(this.getAddress());
    }

    public JAXRSClientFactoryBean createJAXRSClientFactoryBean(String address) {
        JAXRSClientFactoryBean answer = this.newJAXRSClientFactoryBean();
        this.setupJAXRSClientFactoryBean(answer, address);
        if (!this.getProviders().isEmpty()) {
            answer.setProviders(this.getProviders());
        }
        if (this.schemaLocations != null) {
            answer.setSchemaLocations(this.schemaLocations);
        }
        if (this.isLoggingFeatureEnabled()) {
            if (this.getLoggingSizeLimit() > 0) {
                answer.getFeatures().add(new LoggingFeature(this.getLoggingSizeLimit()));
            } else {
                answer.getFeatures().add(new LoggingFeature());
            }
        }
        if (this.isSkipFaultLogging()) {
            if (answer.getProperties() == null) {
                answer.setProperties(new HashMap());
            }
            answer.getProperties().put(FaultListener.class.getName(), new NullFaultListener());
        }
        return answer;
    }

    public List<Class<?>> getResourceClasses() {
        return this.resourceClasses;
    }

    public void addResourceClass(Class<?> resourceClass) {
        if (this.resourceClasses == null) {
            this.resourceClasses = new ArrayList();
        }
        this.resourceClasses.add(resourceClass);
    }

    public void setResourceClasses(List<Class<?>> resourceClasses) {
        this.resourceClasses = resourceClasses;
    }

    public void setResourceClasses(Class<?> ... classes) {
        this.setResourceClasses(Arrays.asList(classes));
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.resolvePropertyPlaceholders(this.address);
    }

    public boolean isLoggingFeatureEnabled() {
        return this.loggingFeatureEnabled;
    }

    public void setLoggingFeatureEnabled(boolean loggingFeatureEnabled) {
        this.loggingFeatureEnabled = loggingFeatureEnabled;
    }

    public int getLoggingSizeLimit() {
        return this.loggingSizeLimit;
    }

    public void setLoggingSizeLimit(int loggingSizeLimit) {
        this.loggingSizeLimit = loggingSizeLimit;
    }

    public boolean isThrowExceptionOnFailure() {
        return this.throwExceptionOnFailure;
    }

    public void setThrowExceptionOnFailure(boolean throwExceptionOnFailure) {
        this.throwExceptionOnFailure = throwExceptionOnFailure;
    }

    public void setMaxClientCacheSize(int maxClientCacheSize) {
        this.maxClientCacheSize = maxClientCacheSize;
    }

    public int getMaxClientCacheSize() {
        return this.maxClientCacheSize;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
        if (this.isSetDefaultBus) {
            BusFactory.setDefaultBus((Bus)bus);
            LOG.debug("Set bus {} as thread default bus", (Object)bus);
        }
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setSetDefaultBus(boolean isSetDefaultBus) {
        this.isSetDefaultBus = isSetDefaultBus;
    }

    public boolean isSetDefaultBus() {
        return this.isSetDefaultBus;
    }

    public BindingStyle getBindingStyle() {
        return this.bindingStyle;
    }

    public List<?> getProviders() {
        return this.entityProviders;
    }

    public void setProviders(List<?> providers) {
        this.entityProviders.addAll(providers);
    }

    public void setProvider(Object provider) {
        this.entityProviders.add(provider);
    }

    public void setSchemaLocation(String schema) {
        this.setSchemaLocations(Collections.singletonList(schema));
    }

    public void setSchemaLocations(List<String> schemas) {
        this.schemaLocations = schemas;
    }

    public List<String> getSchemaLocations() {
        return this.schemaLocations;
    }

    public void setBindingStyle(BindingStyle bindingStyle) {
        this.bindingStyle = bindingStyle;
    }

    protected void doStart() throws Exception {
        if (this.headerFilterStrategy == null) {
            this.headerFilterStrategy = new CxfRsHeaderFilterStrategy();
        }
        CxfRsBinding cxfRsBinding = this.binding = this.bindingStyle == null || this.bindingStyle == BindingStyle.Default ? new DefaultCxfRsBinding() : new SimpleCxfRsBinding();
        if (this.binding instanceof HeaderFilterStrategyAware) {
            ((HeaderFilterStrategyAware)this.binding).setHeaderFilterStrategy(this.getHeaderFilterStrategy());
        }
    }

    protected void doStop() throws Exception {
    }

    public static enum BindingStyle {
        SimpleConsumer,
        Default;

    }
}

