/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.impl.HeaderFilterStrategyComponent;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.IntrospectionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CxfComponent
extends HeaderFilterStrategyComponent
implements SSLContextParametersAware {
    private static final Logger LOG = LoggerFactory.getLogger(CxfComponent.class);
    @Metadata(label="advanced")
    private Boolean allowStreaming;
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;

    public CxfComponent() {
        super(CxfEndpoint.class);
    }

    public CxfComponent(CamelContext context) {
        super(context, CxfEndpoint.class);
    }

    public void setAllowStreaming(Boolean allowStreaming) {
        this.allowStreaming = allowStreaming;
    }

    public Boolean isAllowStreaming() {
        return this.allowStreaming;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        CxfEndpoint result;
        Object value = parameters.remove("setDefaultBus");
        if (value != null) {
            LOG.warn("The option setDefaultBus is @deprecated, use name defaultBus instead");
            if (!parameters.containsKey("defaultBus")) {
                parameters.put("defaultBus", value);
            }
        }
        if (this.allowStreaming != null && !parameters.containsKey("allowStreaming")) {
            parameters.put("allowStreaming", Boolean.toString(this.allowStreaming));
        }
        if (remaining.startsWith("bean:")) {
            String beanId = remaining.substring("bean:".length());
            if (beanId.startsWith("//")) {
                beanId = beanId.substring(2);
            }
            result = this.createCxfSpringEndpoint(beanId);
            if (this.getCamelContext().equals(result.getCamelContext())) {
                result.setCamelContext(this.getCamelContext());
            }
            result.setBeanId(beanId);
        } else {
            result = this.createCxfEndpoint(remaining);
        }
        if (result.getCamelContext() == null) {
            result.setCamelContext(this.getCamelContext());
        }
        this.setEndpointHeaderFilterStrategy((Endpoint)result);
        this.setProperties(result, parameters);
        Map properties = IntrospectionSupport.extractProperties(parameters, (String)"properties.");
        if (properties != null) {
            result.setProperties(properties);
        }
        if (result.getProperties() != null) {
            result.setMtomEnabled(Boolean.valueOf((String)result.getProperties().get("mtom-enabled")));
        }
        if (result.getSslContextParameters() == null) {
            result.setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        return result;
    }

    protected CxfEndpoint createCxfSpringEndpoint(String beanId) throws Exception {
        return (CxfEndpoint)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)beanId, CxfEndpoint.class);
    }

    protected CxfEndpoint createCxfEndpoint(String remaining) {
        return new CxfEndpoint(remaining, this);
    }

    protected void afterConfiguration(String uri, String remaining, Endpoint endpoint, Map<String, Object> parameters) throws Exception {
        CxfEndpoint cxfEndpoint = (CxfEndpoint)endpoint;
        cxfEndpoint.updateEndpointUri(uri);
    }
}

