/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.interceptors;

import org.apache.cxf.binding.soap.interceptor.SoapHeaderInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveClassTypeInterceptor
extends AbstractPhaseInterceptor<Message> {
    public RemoveClassTypeInterceptor() {
        super("unmarshal");
        this.addBefore(SoapHeaderInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        Exchange exchange = message.getExchange();
        BindingOperationInfo bop = exchange.getBindingOperationInfo();
        if (bop == null) {
            return;
        }
        if (bop.isUnwrapped()) {
            bop = bop.getWrappedOperation();
        }
        if (bop.isUnwrappedCapable()) {
            this.removePartTypeClass(bop.getWrappedOperation().getOperationInfo().getInput());
            this.removePartTypeClass(bop.getWrappedOperation().getOperationInfo().getOutput());
            this.removePartTypeClass(bop.getWrappedOperation().getInput());
            this.removePartTypeClass(bop.getWrappedOperation().getOutput());
        } else {
            this.removePartTypeClass(bop.getOperationInfo().getInput());
            this.removePartTypeClass(bop.getOperationInfo().getOutput());
            this.removePartTypeClass(bop.getInput());
            this.removePartTypeClass(bop.getOutput());
        }
    }

    protected void removePartTypeClass(BindingMessageInfo bmi) {
        if (bmi != null) {
            for (MessagePartInfo part : bmi.getMessageParts()) {
                part.setTypeClass(null);
            }
        }
    }

    protected void removePartTypeClass(MessageInfo msgInfo) {
        if (msgInfo != null) {
            for (MessagePartInfo part : msgInfo.getMessageParts()) {
                part.setTypeClass(null);
            }
        }
    }
}

