/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.cxf.jaxrs.CxfRsBinding;
import org.apache.camel.component.cxf.jaxrs.CxfRsConsumer;
import org.apache.camel.component.cxf.jaxrs.CxfRsHeaderFilterStrategy;
import org.apache.camel.component.cxf.jaxrs.CxfRsProducer;
import org.apache.camel.component.cxf.jaxrs.DefaultCxfRsBinding;
import org.apache.camel.component.cxf.spring.CxfRsClientFactoryBeanDefinitionParser;
import org.apache.camel.component.cxf.spring.CxfRsServerFactoryBeanDefinitionParser;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfRsEndpoint
extends DefaultEndpoint
implements HeaderFilterStrategyAware {
    private static final Log LOG = LogFactory.getLog(CxfRsEndpoint.class);
    private Map<String, String> parameters;
    private List<Class<?>> resourceClasses;
    private HeaderFilterStrategy headerFilterStrategy;
    private CxfRsBinding binding;
    private boolean httpClientAPI = true;
    private String address;
    private boolean throwExceptionOnFailure = true;
    private int maxClientCacheSize = 10;
    private AtomicBoolean bindingInitialized = new AtomicBoolean(false);

    public CxfRsEndpoint(String endpointUri, CamelContext camelContext) {
        super(endpointUri, camelContext);
        this.setAddress(endpointUri);
    }

    public CxfRsEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
        this.setAddress(endpointUri);
    }

    protected void updateEndpointUri(String endpointUri) {
        super.setEndpointUri(endpointUri);
    }

    public void setParameters(Map<String, String> param) {
        this.parameters = param;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setHttpClientAPI(boolean clientAPI) {
        this.httpClientAPI = clientAPI;
    }

    public boolean isHttpClientAPI() {
        return this.httpClientAPI;
    }

    public boolean isLenientProperties() {
        return true;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        if (this.headerFilterStrategy == null) {
            this.headerFilterStrategy = new CxfRsHeaderFilterStrategy();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Create default header filter strategy " + this.headerFilterStrategy));
            }
        }
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
        if (this.binding instanceof HeaderFilterStrategyAware) {
            ((HeaderFilterStrategyAware)this.binding).setHeaderFilterStrategy(this.headerFilterStrategy);
        }
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new CxfRsConsumer(this, processor);
    }

    public Producer createProducer() throws Exception {
        return new CxfRsProducer(this);
    }

    public boolean isSingleton() {
        return false;
    }

    public void setBinding(CxfRsBinding binding) {
        this.binding = binding;
        this.bindingInitialized.set(false);
    }

    public synchronized CxfRsBinding getBinding() {
        if (this.binding == null) {
            this.binding = new DefaultCxfRsBinding();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Create default CXF Binding " + this.binding));
            }
        }
        if (!this.bindingInitialized.getAndSet(true) && this.binding instanceof HeaderFilterStrategyAware) {
            ((HeaderFilterStrategyAware)this.binding).setHeaderFilterStrategy(this.getHeaderFilterStrategy());
        }
        return this.binding;
    }

    protected void setupJAXRSServerFactoryBean(JAXRSServerFactoryBean sfb) {
        sfb.setAddress(this.getAddress());
        sfb.setResourceClasses(CastUtils.cast(this.getResourceClasses(), Class.class));
        sfb.setStart(false);
    }

    protected void setupJAXRSClientFactoryBean(JAXRSClientFactoryBean cfb, String address) {
        cfb.setAddress(address);
        if (this.getResourceClasses() != null) {
            cfb.setResourceClass(this.getResourceClasses().get(0));
        }
    }

    public JAXRSServerFactoryBean createJAXRSServerFactoryBean() {
        CxfRsServerFactoryBeanDefinitionParser.SpringJAXRSServerFactoryBean answer = new CxfRsServerFactoryBeanDefinitionParser.SpringJAXRSServerFactoryBean();
        this.setupJAXRSServerFactoryBean(answer);
        return answer;
    }

    public JAXRSClientFactoryBean createJAXRSClientFactoryBean() {
        return this.createJAXRSClientFactoryBean(this.getAddress());
    }

    public JAXRSClientFactoryBean createJAXRSClientFactoryBean(String address) {
        CxfRsClientFactoryBeanDefinitionParser.SpringJAXRSClientFactoryBean answer = new CxfRsClientFactoryBeanDefinitionParser.SpringJAXRSClientFactoryBean();
        this.setupJAXRSClientFactoryBean(answer, address);
        return answer;
    }

    public List<Class<?>> getResourceClasses() {
        return this.resourceClasses;
    }

    public void setResourceClasses(List<Class<?>> classes) {
        this.resourceClasses = classes;
    }

    public void setResourceClasses(Class<?> ... classes) {
        this.setResourceClasses(Arrays.asList(classes));
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public boolean isThrowExceptionOnFailure() {
        return this.throwExceptionOnFailure;
    }

    public void setThrowExceptionOnFailure(boolean throwExceptionOnFailure) {
        this.throwExceptionOnFailure = throwExceptionOnFailure;
    }

    public void setMaxClientCacheSize(int maxClientCacheSize) {
        this.maxClientCacheSize = maxClientCacheSize;
    }

    public int getMaxClientCacheSize() {
        return this.maxClientCacheSize;
    }
}

