/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import org.apache.camel.CamelContext;
import org.apache.camel.component.cxf.jaxrs.BeanIdAware;
import org.apache.camel.component.cxf.jaxrs.CxfRsEndpoint;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.cxf.configuration.spring.ConfigurerImpl;
import org.apache.cxf.jaxrs.AbstractJAXRSFactoryBean;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfRsSpringEndpoint
extends CxfRsEndpoint
implements BeanIdAware {
    private AbstractJAXRSFactoryBean bean;
    private ApplicationContext applicationContext;
    private String beanId;
    private ConfigurerImpl configurer;

    public CxfRsSpringEndpoint(CamelContext context, AbstractJAXRSFactoryBean bean) throws Exception {
        super(bean.getAddress(), context);
        this.init(bean);
    }

    private void init(AbstractJAXRSFactoryBean bean) {
        this.bean = bean;
        if (bean instanceof BeanIdAware) {
            this.setBeanId(((BeanIdAware)bean).getBeanId());
        }
        this.applicationContext = ((SpringCamelContext)this.getCamelContext()).getApplicationContext();
        this.configurer = new ConfigurerImpl(this.applicationContext);
    }

    void configure(Object beanInstance) {
        AbstractApplicationContext context;
        if (this.applicationContext instanceof AbstractApplicationContext && !(context = (AbstractApplicationContext)this.applicationContext).isActive()) {
            context.refresh();
        }
        this.configurer.configureBean(this.beanId, beanInstance);
    }

    void checkBeanType(Class<?> clazz) {
        if (!clazz.isAssignableFrom(this.bean.getClass())) {
            throw new IllegalArgumentException("The configure bean is not the instance of " + clazz.getName());
        }
    }

    @Override
    protected void setupJAXRSServerFactoryBean(JAXRSServerFactoryBean sfb) {
        this.checkBeanType(JAXRSServerFactoryBean.class);
        this.configure(sfb);
    }

    @Override
    protected void setupJAXRSClientFactoryBean(JAXRSClientFactoryBean cfb, String address) {
        this.checkBeanType(JAXRSClientFactoryBean.class);
        this.configure(cfb);
        cfb.setAddress(address);
    }

    @Override
    public String getBeanId() {
        return this.beanId;
    }

    @Override
    public void setBeanId(String id) {
        this.beanId = id;
    }
}

