/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.interceptors;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.camel.util.IOHelper;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class RawMessageContentRedirectInterceptor
extends AbstractPhaseInterceptor<Message> {
    public RawMessageContentRedirectInterceptor() {
        super("write");
    }

    public void handleMessage(Message message) throws Fault {
        Throwable ex = (Throwable)message.getContent(Throwable.class);
        if (ex != null) {
            if (ex instanceof Fault) {
                throw (Fault)ex;
            }
            throw new Fault(ex);
        }
        List params = (List)message.getContent(List.class);
        if (null != params) {
            InputStream is = (InputStream)params.get(0);
            OutputStream os = (OutputStream)message.getContent(OutputStream.class);
            try {
                IOHelper.copy((InputStream)is, (OutputStream)os);
            }
            catch (Exception e) {
                throw new Fault((Throwable)e);
            }
            finally {
                IOHelper.close((Closeable)is, (String)"input stream", null);
            }
        }
    }
}

