/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.consumer.adapters;

import java.io.File;
import org.apache.camel.component.file.consumer.FileResumeSet;
import org.apache.camel.component.file.consumer.FileSetResumeAdapter;
import org.apache.camel.resume.cache.MultiEntryCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileSetResumeAdapter
implements FileSetResumeAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFileSetResumeAdapter.class);
    private final MultiEntryCache<File, File> cache;

    public DefaultFileSetResumeAdapter(MultiEntryCache<File, File> cache) {
        this.cache = cache;
    }

    private boolean notProcessed(File file) {
        File key = file.getParentFile();
        boolean ret = !this.cache.contains((Object)key, (Object)file);
        return ret;
    }

    @Override
    public void resume(FileResumeSet resumable) {
        if (resumable != null) {
            resumable.resumeEach(this::notProcessed);
            if (resumable.hasResumables()) {
                LOG.debug("There's {} files to still to be processed", (Object)resumable.resumed().length);
            }
        } else {
            LOG.trace("Nothing to resume");
        }
    }

    public void resume() {
    }
}

