/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.freemarker;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.ResourceBasedEndpoint;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;

public class FreemarkerEndpoint
extends ResourceBasedEndpoint {
    private String encoding;
    private Configuration configuration;

    public FreemarkerEndpoint() {
    }

    public FreemarkerEndpoint(String uri, Component component, String resourceUri) {
        super(uri, component, resourceUri, null);
    }

    public boolean isSingleton() {
        return true;
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    protected String createEndpointUri() {
        return "freemarker:" + this.getResourceUri();
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public FreemarkerEndpoint findOrCreateEndpoint(String uri, String newResourceUri) {
        String newUri = uri.replace(this.getResourceUri(), newResourceUri);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Getting endpoint with URI: " + newUri));
        }
        return (FreemarkerEndpoint)this.getCamelContext().getEndpoint(newUri);
    }

    protected void onExchange(Exchange exchange) throws Exception {
        Template template;
        String path = this.getResourceUri();
        ObjectHelper.notNull((Object)this.configuration, (String)"configuration");
        ObjectHelper.notNull((Object)path, (String)"resourceUri");
        String newResourceUri = (String)exchange.getIn().getHeader("CamelFreemarkerResourceUri", String.class);
        if (newResourceUri != null) {
            exchange.getIn().removeHeader("CamelFreemarkerResourceUri");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("CamelFreemarkerResourceUri set to " + newResourceUri + " creating new endpoint to handle exchange"));
            }
            FreemarkerEndpoint newEndpoint = this.findOrCreateEndpoint(this.getEndpointUri(), newResourceUri);
            newEndpoint.onExchange(exchange);
            return;
        }
        StringReader reader = null;
        String content = (String)exchange.getIn().getHeader("CamelFreemarkerTemplate", String.class);
        if (content != null) {
            reader = new StringReader(content);
            exchange.getIn().removeHeader("CamelFreemarkerTemplate");
        }
        Map variableMap = ExchangeHelper.createVariableMap((Exchange)exchange);
        if (reader != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Freemarker is evaluating template read from header CamelFreemarkerTemplate using context: " + variableMap));
            }
            template = new Template("temp", (Reader)reader, new Configuration());
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Freemarker is evaluating " + path + " using context: " + variableMap));
            }
            template = this.getEncoding() != null ? this.configuration.getTemplate(path, this.getEncoding()) : this.configuration.getTemplate(path);
        }
        StringWriter buffer = new StringWriter();
        template.process((Object)variableMap, (Writer)buffer);
        buffer.flush();
        Message out = exchange.getOut();
        out.setBody((Object)buffer.toString());
        Map headers = (Map)variableMap.get("headers");
        for (Map.Entry entry : headers.entrySet()) {
            out.setHeader((String)entry.getKey(), entry.getValue());
        }
    }
}

