/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import org.apache.camel.Exchange;
import org.apache.camel.ServicePoolAware;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileProducer;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteFileProducer<T>
extends GenericFileProducer<T>
implements ServicePoolAware {
    private boolean loggedIn;

    protected RemoteFileProducer(RemoteFileEndpoint<T> endpoint, RemoteFileOperations<T> operations) {
        super(endpoint, operations);
    }

    public String getFileSeparator() {
        return "/";
    }

    public String normalizePath(String name) {
        return name;
    }

    public void process(Exchange exchange) throws Exception {
        Exchange remoteExchange = this.getEndpoint().createExchange(exchange);
        this.processExchange(remoteExchange);
        ExchangeHelper.copyResults((Exchange)exchange, (Exchange)remoteExchange);
    }

    protected RemoteFileOperations getOperations() {
        return (RemoteFileOperations)this.operations;
    }

    public RemoteFileEndpoint<T> getEndpoint() {
        return (RemoteFileEndpoint)super.getEndpoint();
    }

    public void handleFailedWrite(Exchange exchange, Exception exception) throws Exception {
        this.loggedIn = false;
        if (!this.isStopping() && !this.isStopped()) {
            this.log.warn((Object)("Writing file failed with: " + exception.getMessage()));
            try {
                this.disconnect();
            }
            catch (Exception e) {
                this.log.debug((Object)("Ignored exception during disconnect: " + e.getMessage()));
            }
            throw exception;
        }
        this.log.debug((Object)("Exception occurred during stopping: " + exception.getMessage()));
    }

    public void disconnect() throws GenericFileOperationFailedException {
        this.loggedIn = false;
        if (this.getOperations().isConnected()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Disconnecting from: " + this.getEndpoint()));
            }
            this.getOperations().disconnect();
        }
    }

    public void preWriteCheck() throws Exception {
        boolean noop = false;
        if (this.loggedIn) {
            try {
                noop = this.getOperations().sendNoop();
            }
            catch (Exception e) {
                noop = false;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("preWriteCheck send noop success: " + noop));
        }
        if (!noop) {
            try {
                if (this.getEndpoint().getMaximumReconnectAttempts() > 0) {
                    this.recoverableConnectIfNecessary();
                } else {
                    this.connectIfNecessary();
                }
            }
            catch (Exception e) {
                this.loggedIn = false;
                throw e;
            }
        }
    }

    public void postWriteCheck() {
        try {
            if (this.getEndpoint().isDisconnect()) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("postWriteCheck disconnect from: " + this.getEndpoint()));
                }
                this.disconnect();
            }
        }
        catch (GenericFileOperationFailedException e) {
            this.log.warn((Object)("Exception occurred during disconnecting from: " + this.getEndpoint() + " " + e.getMessage()));
        }
    }

    protected void doStart() throws Exception {
        this.log.debug((Object)"Starting");
        super.doStart();
    }

    protected void doStop() throws Exception {
        try {
            this.disconnect();
        }
        catch (Exception e) {
            this.log.debug((Object)("Exception occurred during disconnecting from: " + this.getEndpoint() + " " + e.getMessage()));
        }
        super.doStop();
    }

    protected void recoverableConnectIfNecessary() throws Exception {
        block6: {
            try {
                this.connectIfNecessary();
            }
            catch (Exception e) {
                this.loggedIn = false;
                InterruptedException ie = (InterruptedException)ObjectHelper.getException(InterruptedException.class, (Throwable)e);
                if (ie != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Interrupted during connect to: " + this.getEndpoint()), (Throwable)ie);
                    }
                    throw ie;
                }
                if (!this.log.isDebugEnabled()) break block6;
                this.log.debug((Object)("Could not connect to: " + this.getEndpoint() + ". Will try to recover."), (Throwable)e);
            }
        }
        if (!this.loggedIn) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Trying to recover connection to: " + this.getEndpoint() + " with a fresh client."));
            }
            this.setOperations(this.getEndpoint().createRemoteFileOperations());
            this.connectIfNecessary();
        }
    }

    protected void connectIfNecessary() throws GenericFileOperationFailedException {
        if (!this.loggedIn) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Not already connected/logged in. Connecting to: " + this.getEndpoint()));
            }
            RemoteFileConfiguration config = this.getEndpoint().getConfiguration();
            this.loggedIn = this.getOperations().connect(config);
            if (!this.loggedIn) {
                return;
            }
            this.log.info((Object)("Connected and logged in to: " + this.getEndpoint()));
        }
    }

    public boolean isSingleton() {
        return false;
    }
}

