/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SocketFactory;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.time.Duration;
import java.util.Base64;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.LoggingLevel;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExist;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.remote.RemoteFile;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.component.file.remote.SftpConfiguration;
import org.apache.camel.component.file.remote.SftpEndpoint;
import org.apache.camel.component.file.remote.SftpRemoteFile;
import org.apache.camel.component.file.remote.SftpRemoteFileJCraft;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.task.ForegroundTask;
import org.apache.camel.support.task.Tasks;
import org.apache.camel.support.task.budget.Budgets;
import org.apache.camel.support.task.budget.IterationBudget;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.slf4j.LoggerFactory;

public class SftpOperations
implements RemoteFileOperations<SftpRemoteFile> {
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(SftpOperations.class);
    private static final Pattern UP_DIR_PATTERN = Pattern.compile("/[^/]+");
    private static final int OK_STATUS = 0;
    private static final String OK_MESSAGE = "OK";
    private Proxy proxy;
    private SftpEndpoint endpoint;
    private ChannelSftp channel;
    private Session session;

    public SftpOperations() {
    }

    public SftpOperations(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setEndpoint(GenericFileEndpoint<SftpRemoteFile> endpoint) {
        this.endpoint = (SftpEndpoint)endpoint;
    }

    public GenericFile<SftpRemoteFile> newGenericFile() {
        return new RemoteFile<SftpRemoteFile>();
    }

    @Override
    public synchronized boolean connect(RemoteFileConfiguration configuration, Exchange exchange) throws GenericFileOperationFailedException {
        TaskPayload payload;
        if (this.isConnected()) {
            return true;
        }
        ForegroundTask task = Tasks.foregroundTask().withBudget((IterationBudget)Budgets.iterationBudget().withMaxIterations(Budgets.atLeastOnce((int)this.endpoint.getMaximumReconnectAttempts())).withInterval(Duration.ofMillis(this.endpoint.getReconnectDelay())).build()).build();
        if (!task.run(this::tryConnect, (Object)(payload = new TaskPayload(configuration)))) {
            throw new GenericFileOperationFailedException("Cannot connect to " + configuration.remoteServerInformation(), (Throwable)payload.exception);
        }
        this.configureBulkRequests();
        return true;
    }

    private boolean tryConnect(TaskPayload payload) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Reconnect attempt to {}", (Object)payload.configuration.remoteServerInformation());
        }
        try {
            if (this.channel == null || !this.channel.isConnected()) {
                if (this.session == null || !this.session.isConnected()) {
                    LOG.trace("Session isn't connected, trying to recreate and connect.");
                    this.session = this.createSession(payload.configuration);
                    if (this.endpoint.getConfiguration().getConnectTimeout() > 0) {
                        LOG.trace("Connecting use connectTimeout: {} ...", (Object)this.endpoint.getConfiguration().getConnectTimeout());
                        this.session.connect(this.endpoint.getConfiguration().getConnectTimeout());
                    } else {
                        LOG.trace("Connecting ...");
                        this.session.connect();
                    }
                }
                LOG.trace("Channel isn't connected, trying to recreate and connect.");
                this.channel = (ChannelSftp)this.session.openChannel("sftp");
                if (this.endpoint.getConfiguration().getConnectTimeout() > 0) {
                    LOG.trace("Connecting use connectTimeout: {} ...", (Object)this.endpoint.getConfiguration().getConnectTimeout());
                    this.channel.connect(this.endpoint.getConfiguration().getConnectTimeout());
                } else {
                    LOG.trace("Connecting ...");
                    this.channel.connect();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Connected to {}", (Object)payload.configuration.remoteServerInformation());
                }
            }
        }
        catch (JSchException e) {
            payload.exception = e;
            return false;
        }
        return true;
    }

    private void configureBulkRequests() {
        try {
            this.tryConfigureBulkRequests();
        }
        catch (JSchException e) {
            throw new GenericFileOperationFailedException("Failed to configure number of bulk requests", (Throwable)e);
        }
    }

    private void tryConfigureBulkRequests() throws JSchException {
        Integer bulkRequests = this.endpoint.getConfiguration().getBulkRequests();
        if (bulkRequests != null) {
            LOG.trace("configuring channel to use up to {} bulk request(s)", (Object)bulkRequests);
            this.channel.setBulkRequests(bulkRequests.intValue());
        }
    }

    protected Session createSession(final RemoteFileConfiguration configuration) throws JSchException {
        Object knownHostsFile;
        byte[] passphrase;
        JSch jsch = new JSch();
        JSch.setLogger((Logger)new JSchLogger(this.endpoint.getConfiguration().getJschLoggingLevel()));
        final SftpConfiguration sftpConfig = (SftpConfiguration)configuration;
        if (ObjectHelper.isNotEmpty((Object)sftpConfig.getCiphers())) {
            LOG.debug("Using ciphers: {}", (Object)sftpConfig.getCiphers());
            Hashtable<String, String> ciphers = new Hashtable<String, String>();
            ciphers.put("cipher.s2c", sftpConfig.getCiphers());
            ciphers.put("cipher.c2s", sftpConfig.getCiphers());
            JSch.setConfig(ciphers);
        }
        if (ObjectHelper.isNotEmpty((Object)sftpConfig.getKeyExchangeProtocols())) {
            LOG.debug("Using KEX: {}", (Object)sftpConfig.getKeyExchangeProtocols());
            JSch.setConfig((String)"kex", (String)sftpConfig.getKeyExchangeProtocols());
        }
        if (ObjectHelper.isNotEmpty((Object)sftpConfig.getPrivateKeyFile())) {
            LOG.debug("Using private keyfile: {}", (Object)sftpConfig.getPrivateKeyFile());
            if (ObjectHelper.isNotEmpty((Object)sftpConfig.getPrivateKeyPassphrase())) {
                jsch.addIdentity(sftpConfig.getPrivateKeyFile(), sftpConfig.getPrivateKeyPassphrase());
            } else {
                jsch.addIdentity(sftpConfig.getPrivateKeyFile());
            }
        }
        if (sftpConfig.getPrivateKey() != null) {
            LOG.debug("Using private key information from byte array");
            passphrase = null;
            if (ObjectHelper.isNotEmpty((Object)sftpConfig.getPrivateKeyPassphrase())) {
                passphrase = sftpConfig.getPrivateKeyPassphrase().getBytes(StandardCharsets.UTF_8);
            }
            jsch.addIdentity("ID", sftpConfig.getPrivateKey(), null, passphrase);
        }
        if (sftpConfig.getPrivateKeyUri() != null) {
            LOG.debug("Using private key uri : {}", (Object)sftpConfig.getPrivateKeyUri());
            passphrase = null;
            if (ObjectHelper.isNotEmpty((Object)sftpConfig.getPrivateKeyPassphrase())) {
                passphrase = sftpConfig.getPrivateKeyPassphrase().getBytes(StandardCharsets.UTF_8);
            }
            try {
                InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.endpoint.getCamelContext(), (String)sftpConfig.getPrivateKeyUri());
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)bos);
                jsch.addIdentity("ID", bos.toByteArray(), null, passphrase);
            }
            catch (IOException e) {
                throw new JSchException("Cannot read resource: " + sftpConfig.getPrivateKeyUri(), (Throwable)e);
            }
        }
        if (sftpConfig.getKeyPair() != null) {
            LOG.debug("Using private key information from key pair");
            KeyPair keyPair = sftpConfig.getKeyPair();
            if (keyPair.getPrivate() != null) {
                StringBuilder sb = new StringBuilder(256);
                sb.append("-----BEGIN PRIVATE KEY-----").append("\n");
                sb.append(Base64.getEncoder().encodeToString(keyPair.getPrivate().getEncoded())).append("\n");
                sb.append("-----END PRIVATE KEY-----").append("\n");
                jsch.addIdentity("ID", sb.toString().getBytes(StandardCharsets.UTF_8), null, null);
            } else {
                LOG.warn("PrivateKey in the KeyPair must be filled");
            }
        }
        if (ObjectHelper.isNotEmpty((Object)sftpConfig.getKnownHostsFile())) {
            LOG.debug("Using knownhosts file: {}", (Object)sftpConfig.getKnownHostsFile());
            jsch.setKnownHosts(sftpConfig.getKnownHostsFile());
        }
        if (ObjectHelper.isNotEmpty((Object)sftpConfig.getKnownHostsUri())) {
            LOG.debug("Using known hosts uri: {}", (Object)sftpConfig.getKnownHostsUri());
            try {
                InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.endpoint.getCamelContext(), (String)sftpConfig.getKnownHostsUri());
                jsch.setKnownHosts(is);
            }
            catch (IOException e) {
                throw new JSchException("Cannot read resource: " + sftpConfig.getKnownHostsUri(), (Throwable)e);
            }
        }
        if (sftpConfig.getKnownHosts() != null) {
            LOG.debug("Using known hosts information from byte array");
            jsch.setKnownHosts((InputStream)new ByteArrayInputStream(sftpConfig.getKnownHosts()));
        }
        if ((knownHostsFile = sftpConfig.getKnownHostsFile()) == null && sftpConfig.isUseUserKnownHostsFile()) {
            knownHostsFile = System.getProperty("user.home") + "/.ssh/known_hosts";
            LOG.info("Known host file not configured, using user known host file: {}", knownHostsFile);
        }
        if (ObjectHelper.isNotEmpty((Object)knownHostsFile)) {
            LOG.debug("Using known hosts information from file: {}", knownHostsFile);
            jsch.setKnownHosts((String)knownHostsFile);
        }
        final Session session = jsch.getSession(configuration.getUsername(), configuration.getHost(), configuration.getPort());
        if (ObjectHelper.isNotEmpty((Object)sftpConfig.getStrictHostKeyChecking())) {
            LOG.debug("Using StrictHostKeyChecking: {}", (Object)sftpConfig.getStrictHostKeyChecking());
            session.setConfig("StrictHostKeyChecking", sftpConfig.getStrictHostKeyChecking());
        }
        session.setServerAliveInterval(sftpConfig.getServerAliveInterval());
        session.setServerAliveCountMax(sftpConfig.getServerAliveCountMax());
        if (sftpConfig.getCompression() > 0) {
            LOG.debug("Using compression: {}", (Object)sftpConfig.getCompression());
            session.setConfig("compression.s2c", "zlib@openssh.com,zlib,none");
            session.setConfig("compression.c2s", "zlib@openssh.com,zlib,none");
            session.setConfig("compression_level", Integer.toString(sftpConfig.getCompression()));
        }
        if (sftpConfig.getPreferredAuthentications() != null) {
            LOG.debug("Using PreferredAuthentications: {}", (Object)sftpConfig.getPreferredAuthentications());
            session.setConfig("PreferredAuthentications", sftpConfig.getPreferredAuthentications());
        }
        session.setUserInfo((UserInfo)new ExtendedUserInfo(){

            public String getPassphrase() {
                return null;
            }

            public String getPassword() {
                return configuration.getPassword();
            }

            public boolean promptPassword(String s) {
                return true;
            }

            public boolean promptPassphrase(String s) {
                return true;
            }

            public boolean promptYesNo(String s) {
                LOG.warn("Server asks for confirmation (yes|no): {}. Camel will answer no.", (Object)s);
                return false;
            }

            public void showMessage(String s) {
                LOG.trace("Message received from Server: {}", (Object)s);
            }

            public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
                if (configuration.getPassword() == null) {
                    return new String[0];
                }
                return new String[]{configuration.getPassword()};
            }
        });
        if (sftpConfig.getServerAliveInterval() == 0) {
            if (configuration.getSoTimeout() > 0) {
                session.setTimeout(configuration.getSoTimeout());
            }
        } else {
            LOG.debug("The Server Alive Internal is already set, the socket timeout won't be considered to avoid overidding the provided Server alive interval value");
        }
        if (this.proxy != null) {
            session.setProxy(this.proxy);
        }
        if (ObjectHelper.isNotEmpty((Object)sftpConfig.getBindAddress())) {
            session.setSocketFactory(new SocketFactory(){

                public OutputStream getOutputStream(Socket socket) throws IOException {
                    return socket.getOutputStream();
                }

                public InputStream getInputStream(Socket socket) throws IOException {
                    return socket.getInputStream();
                }

                public Socket createSocket(String host, int port) throws IOException {
                    return SftpOperations.createSocketUtil(host, port, sftpConfig.getBindAddress(), session.getTimeout());
                }
            });
        }
        return session;
    }

    @Override
    public synchronized boolean isConnected() throws GenericFileOperationFailedException {
        return this.session != null && this.session.isConnected() && this.channel != null && this.channel.isConnected();
    }

    @Override
    public synchronized void disconnect() throws GenericFileOperationFailedException {
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
        }
        if (this.channel != null && this.channel.isConnected()) {
            this.channel.disconnect();
        }
    }

    @Override
    public synchronized void forceDisconnect() throws GenericFileOperationFailedException {
        try {
            if (this.session != null) {
                this.session.disconnect();
            }
            if (this.channel != null) {
                this.channel.disconnect();
            }
        }
        finally {
            this.session = null;
            this.channel = null;
        }
    }

    private void reconnectIfNecessary(Exchange exchange) {
        if (!this.isConnected()) {
            this.connect(this.endpoint.getConfiguration(), exchange);
        }
    }

    public synchronized boolean deleteFile(String name) throws GenericFileOperationFailedException {
        LOG.debug("Deleting file: {}", (Object)name);
        try {
            this.reconnectIfNecessary(null);
            this.channel.rm(name);
            return true;
        }
        catch (SftpException e) {
            LOG.debug("Cannot delete file {}: {}", new Object[]{name, e.getMessage(), e});
            throw new GenericFileOperationFailedException("Cannot delete file: " + name, (Throwable)e);
        }
    }

    public synchronized boolean renameFile(String from, String to) throws GenericFileOperationFailedException {
        LOG.debug("Renaming file: {} to: {}", (Object)from, (Object)to);
        try {
            this.reconnectIfNecessary(null);
            to = FileUtil.compactPath((String)to, (char)'/');
            this.channel.rename(from, to);
            return true;
        }
        catch (SftpException e) {
            LOG.debug("Cannot rename file from: " + from + " to: " + to, (Throwable)e);
            throw new GenericFileOperationFailedException("Cannot rename file from: " + from + " to: " + to, (Throwable)e);
        }
    }

    public synchronized boolean buildDirectory(String directory, boolean absolute) throws GenericFileOperationFailedException {
        boolean success;
        block12: {
            directory = this.endpoint.getConfiguration().normalizePath(directory);
            LOG.trace("buildDirectory({},{})", (Object)directory, (Object)absolute);
            success = false;
            boolean cdCheck = !this.endpoint.getConfiguration().isExistDirCheckUsingLs();
            String originalDirectory = cdCheck ? this.getCurrentDirectory() : null;
            try {
                try {
                    if (cdCheck) {
                        this.channel.cd(directory);
                    } else {
                        this.channel.ls(directory, entry -> 1);
                    }
                    success = true;
                }
                catch (SftpException sftpException) {
                    // empty catch block
                }
                if (success) break block12;
                LOG.debug("Trying to build remote directory: {}", (Object)directory);
                try {
                    this.channel.mkdir(directory);
                    success = true;
                }
                catch (SftpException e) {
                    success = this.buildDirectoryChunks(directory);
                }
                this.chmodOfDirectory(directory);
            }
            catch (SftpException e) {
                throw new GenericFileOperationFailedException("Cannot build directory: " + directory, (Throwable)e);
            }
            finally {
                if (originalDirectory != null) {
                    this.changeCurrentDirectory(originalDirectory);
                }
            }
        }
        return success;
    }

    private boolean buildDirectoryChunks(String dirName) throws SftpException {
        StringBuilder sb = new StringBuilder(dirName.length());
        String[] dirs = dirName.split("/|\\\\");
        boolean success = false;
        boolean first = true;
        for (String dir : dirs) {
            if (first) {
                first = false;
            } else {
                sb.append('/');
            }
            sb.append(dir);
            String directory = this.endpoint.getConfiguration().normalizePath(sb.toString());
            if (directory.equals("/") || directory.equals("\\")) continue;
            try {
                LOG.trace("Trying to build remote directory by chunk: {}", (Object)directory);
                this.channel.mkdir(directory);
                success = true;
            }
            catch (SftpException sftpException) {
                // empty catch block
            }
            this.chmodOfDirectory(directory);
        }
        return success;
    }

    public synchronized String getCurrentDirectory() throws GenericFileOperationFailedException {
        LOG.trace("getCurrentDirectory()");
        try {
            String answer = this.channel.pwd();
            LOG.trace("Current dir: {}", (Object)answer);
            return answer;
        }
        catch (SftpException e) {
            throw new GenericFileOperationFailedException("Cannot get current directory", (Throwable)e);
        }
    }

    public synchronized void changeCurrentDirectory(String path) throws GenericFileOperationFailedException {
        String[] dirs;
        LOG.trace("changeCurrentDirectory({})", (Object)path);
        if (ObjectHelper.isEmpty((Object)path)) {
            return;
        }
        String before = path;
        char separatorChar = '/';
        path = FileUtil.compactPath((String)path, (char)separatorChar);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Compacted path: {} -> {} using separator: {}", new Object[]{before, path, Character.valueOf(separatorChar)});
        }
        if (!this.endpoint.getConfiguration().isStepwise()) {
            this.doChangeDirectory(path);
            return;
        }
        if (this.getCurrentDirectory().startsWith(path)) {
            String p = this.getCurrentDirectory().substring(path.length() - (path.endsWith("/") ? 1 : 0));
            if (p.length() == 0) {
                return;
            }
            path = UP_DIR_PATTERN.matcher(p).replaceAll("/..").substring(1);
        }
        if (FileUtil.hasLeadingSeparator((String)path)) {
            if (!path.matches("^[a-zA-Z]:(//|\\\\).*$")) {
                this.doChangeDirectory(path.substring(0, 1));
                path = path.substring(1);
            } else if (path.matches("^[a-zA-Z]:(//).*$")) {
                this.doChangeDirectory(path.substring(0, 3));
                path = path.substring(3);
            } else if (path.matches("^[a-zA-Z]:(\\\\).*$")) {
                this.doChangeDirectory(path.substring(0, 4));
                path = path.substring(4);
            }
        }
        if ((dirs = path.split("/|\\\\")) == null || dirs.length == 0) {
            this.doChangeDirectory(path);
            return;
        }
        for (String dir : dirs) {
            this.doChangeDirectory(dir);
        }
    }

    private void doChangeDirectory(String path) {
        if (path == null || ".".equals(path) || ObjectHelper.isEmpty((Object)path)) {
            return;
        }
        LOG.trace("Changing directory: {}", (Object)path);
        try {
            this.channel.cd(path);
        }
        catch (SftpException e) {
            throw new GenericFileOperationFailedException("Cannot change directory to: " + path, (Throwable)e);
        }
    }

    public synchronized void changeToParentDirectory() throws GenericFileOperationFailedException {
        LOG.trace("changeToParentDirectory()");
        String current = this.getCurrentDirectory();
        Object parent = FileUtil.compactPath((String)(current + "/.."));
        if (!((String)parent).startsWith("/")) {
            parent = "/" + (String)parent;
        }
        this.changeCurrentDirectory((String)parent);
    }

    public synchronized SftpRemoteFile[] listFiles() throws GenericFileOperationFailedException {
        return this.listFiles(".");
    }

    public synchronized SftpRemoteFile[] listFiles(String path) throws GenericFileOperationFailedException {
        LOG.trace("Listing remote files from path {}", (Object)path);
        if (ObjectHelper.isEmpty((Object)path)) {
            path = ".";
        }
        try {
            Vector files = this.channel.ls(path);
            return (SftpRemoteFile[])files.stream().map(f -> new SftpRemoteFileJCraft((ChannelSftp.LsEntry)f)).toArray(SftpRemoteFileJCraft[]::new);
        }
        catch (SftpException e) {
            throw new GenericFileOperationFailedException("Cannot list directory: " + path, (Throwable)e);
        }
    }

    public synchronized boolean retrieveFile(String name, Exchange exchange, long size) throws GenericFileOperationFailedException {
        LOG.trace("retrieveFile({})", (Object)name);
        if (ObjectHelper.isNotEmpty((Object)this.endpoint.getLocalWorkDirectory())) {
            return this.retrieveFileToFileInLocalWorkDirectory(name, exchange);
        }
        return this.retrieveFileToStreamInBody(name, exchange);
    }

    public synchronized void releaseRetrievedFileResources(Exchange exchange) throws GenericFileOperationFailedException {
        InputStream is = (InputStream)exchange.getIn().getHeader("CamelRemoteFileInputStream", InputStream.class);
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean retrieveFileToStreamInBody(String name, Exchange exchange) throws GenericFileOperationFailedException {
        boolean bl;
        block10: {
            String currentDir = null;
            try {
                GenericFile target = (GenericFile)exchange.getProperty("CamelFileExchangeFile");
                ObjectHelper.notNull((Object)target, (String)"Exchange should have the CamelFileExchangeFile set");
                String remoteName = name;
                if (this.endpoint.getConfiguration().isStepwise()) {
                    currentDir = this.getCurrentDirectory();
                    String path = FileUtil.onlyPath((String)name);
                    if (path != null) {
                        this.changeCurrentDirectory(path);
                    }
                    remoteName = FileUtil.stripPath((String)name);
                }
                InputStream is = this.channel.get(remoteName);
                if (this.endpoint.getConfiguration().isStreamDownload()) {
                    target.setBody((Object)is);
                    exchange.getIn().setHeader("CamelRemoteFileInputStream", (Object)is);
                } else {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)bos);
                    IOHelper.close((Closeable)bos);
                    target.setBody((Object)bos.toByteArray());
                }
                this.createResultHeadersFromExchange(null, exchange);
                bl = true;
                if (currentDir == null) break block10;
            }
            catch (SftpException e) {
                try {
                    this.createResultHeadersFromExchange(e, exchange);
                    throw new GenericFileOperationFailedException("Cannot retrieve file: " + name, (Throwable)e);
                    catch (IOException e2) {
                        throw new GenericFileOperationFailedException("Cannot retrieve file: " + name, (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (currentDir != null) {
                        this.changeCurrentDirectory(currentDir);
                    }
                    throw throwable;
                }
            }
            this.changeCurrentDirectory(currentDir);
        }
        return bl;
    }

    private boolean retrieveFileToFileInLocalWorkDirectory(String name, Exchange exchange) throws GenericFileOperationFailedException {
        FileOutputStream os;
        File temp;
        File local = new File(this.endpoint.getLocalWorkDirectory());
        GenericFile file = (GenericFile)exchange.getProperty("CamelFileExchangeFile");
        ObjectHelper.notNull((Object)file, (String)"Exchange should have the CamelFileExchangeFile set");
        try {
            String relativeName = file.getRelativeFilePath();
            temp = new File(local, relativeName + ".inprogress");
            local = new File(local, relativeName);
            local.mkdirs();
            if (temp.exists() && !FileUtil.deleteFile((File)temp)) {
                throw new GenericFileOperationFailedException("Cannot delete existing local work file: " + temp);
            }
            if (local.exists() && !FileUtil.deleteFile((File)local)) {
                throw new GenericFileOperationFailedException("Cannot delete existing local work file: " + local);
            }
            if (!temp.createNewFile()) {
                throw new GenericFileOperationFailedException("Cannot create new local work file: " + temp);
            }
            os = new FileOutputStream(temp);
            exchange.getIn().setHeader("CamelFileLocalWorkPath", (Object)local.getPath());
        }
        catch (Exception e) {
            throw new GenericFileOperationFailedException("Cannot create new local work file: " + local);
        }
        String currentDir = null;
        try {
            file.setBody((Object)local);
            String remoteName = name;
            if (this.endpoint.getConfiguration().isStepwise()) {
                currentDir = this.getCurrentDirectory();
                String path = FileUtil.onlyPath((String)name);
                if (path != null) {
                    this.changeCurrentDirectory(path);
                }
                remoteName = FileUtil.stripPath((String)name);
            }
            this.channel.get(remoteName, (OutputStream)os);
        }
        catch (SftpException e) {
            try {
                this.createResultHeadersFromExchange(e, exchange);
                LOG.trace("Error occurred during retrieving file: {} to local directory. Deleting local work file: {}", (Object)name, (Object)temp);
                IOHelper.close((Closeable)os, (String)("retrieve: " + name), (org.slf4j.Logger)LOG);
                boolean deleted = FileUtil.deleteFile((File)temp);
                if (!deleted) {
                    LOG.warn("Error occurred during retrieving file: {} to local directory. Cannot delete local work file: {}", (Object)name, (Object)temp);
                }
                throw new GenericFileOperationFailedException("Cannot retrieve file: " + name, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOHelper.close((Closeable)os, (String)("retrieve: " + name), (org.slf4j.Logger)LOG);
                if (currentDir != null) {
                    this.changeCurrentDirectory(currentDir);
                }
                throw throwable;
            }
        }
        IOHelper.close((Closeable)os, (String)("retrieve: " + name), (org.slf4j.Logger)LOG);
        if (currentDir != null) {
            this.changeCurrentDirectory(currentDir);
        }
        this.createResultHeadersFromExchange(null, exchange);
        LOG.debug("Retrieve file to local work file result: true");
        LOG.trace("Renaming local in progress file from: {} to: {}", (Object)temp, (Object)local);
        try {
            if (!FileUtil.renameFile((File)temp, (File)local, (boolean)false)) {
                throw new GenericFileOperationFailedException("Cannot rename local work file from: " + temp + " to: " + local);
            }
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException("Cannot rename local work file from: " + temp + " to: " + local, (Throwable)e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean storeFile(String name, Exchange exchange, long size) throws GenericFileOperationFailedException {
        boolean answer;
        name = this.endpoint.getConfiguration().normalizePath(name);
        LOG.trace("storeFile({})", (Object)name);
        String currentDir = null;
        String path = FileUtil.onlyPath((String)name);
        String targetName = name;
        try {
            if (path != null && this.endpoint.getConfiguration().isStepwise()) {
                currentDir = this.getCurrentDirectory();
                this.changeCurrentDirectory(path);
                targetName = FileUtil.stripPath((String)name);
            }
            answer = this.doStoreFile(name, targetName, exchange);
            if (currentDir == null) return answer;
        }
        catch (Throwable throwable) {
            if (currentDir == null) throw throwable;
            this.changeCurrentDirectory(currentDir);
            throw throwable;
        }
        this.changeCurrentDirectory(currentDir);
        return answer;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doStoreFile(String name, String targetName, Exchange exchange) throws GenericFileOperationFailedException {
        boolean bl;
        LOG.trace("doStoreFile({})", (Object)targetName);
        if (this.endpoint.getFileExist() == GenericFileExist.Ignore || this.endpoint.getFileExist() == GenericFileExist.Fail || this.endpoint.getFileExist() == GenericFileExist.Move) {
            boolean existFile = this.existsFile(targetName);
            if (existFile && this.endpoint.getFileExist() == GenericFileExist.Ignore) {
                LOG.trace("An existing file already exists: {}. Ignore and do not override it.", (Object)name);
                return true;
            }
            if (existFile && this.endpoint.getFileExist() == GenericFileExist.Fail) {
                throw new GenericFileOperationFailedException("File already exist: " + name + ". Cannot write new file.");
            }
            if (existFile && this.endpoint.getFileExist() == GenericFileExist.Move) {
                this.endpoint.getMoveExistingFileStrategy().moveExistingFile((GenericFileEndpoint)this.endpoint, (GenericFileOperations)this, targetName);
            }
        }
        InputStream is = null;
        if (exchange.getIn().getBody() == null) {
            if (!this.endpoint.isAllowNullBody()) {
                throw new GenericFileOperationFailedException("Cannot write null body to file: " + name);
            }
            LOG.trace("Writing empty file.");
            is = new ByteArrayInputStream(new byte[0]);
        }
        try {
            String mode;
            if (is == null) {
                String charset = this.endpoint.getCharset();
                if (charset != null) {
                    is = new ByteArrayInputStream(((String)exchange.getIn().getMandatoryBody(String.class)).getBytes(charset));
                    LOG.trace("Using InputStream {} with charset {}.", (Object)is, (Object)charset);
                } else {
                    is = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
                }
            }
            StopWatch watch = new StopWatch();
            LOG.debug("About to store file: {} using stream: {}", (Object)targetName, is);
            if (this.endpoint.getFileExist() == GenericFileExist.Append) {
                LOG.trace("Client appendFile: {}", (Object)targetName);
                this.channel.put(is, targetName, 2);
            } else {
                LOG.trace("Client storeFile: {}", (Object)targetName);
                this.channel.put(is, targetName);
            }
            if (LOG.isDebugEnabled()) {
                long time = watch.taken();
                LOG.debug("Took {} ({} millis) to store file: {} and FTP client returned: true", new Object[]{TimeUtils.printDuration((long)time), time, targetName});
            }
            if (ObjectHelper.isNotEmpty((Object)(mode = this.endpoint.getConfiguration().getChmod()))) {
                int permissions = Integer.parseInt(mode, 8);
                LOG.trace("Setting chmod: {} on file: {}", (Object)mode, (Object)targetName);
                this.channel.chmod(permissions, targetName);
            }
            this.createResultHeadersFromExchange(null, exchange);
            bl = true;
        }
        catch (SftpException e) {
            try {
                this.createResultHeadersFromExchange(e, exchange);
                throw new GenericFileOperationFailedException("Cannot store file: " + name, (Throwable)e);
                catch (InvalidPayloadException e2) {
                    throw new GenericFileOperationFailedException("Cannot store file: " + name, (Throwable)e2);
                }
                catch (UnsupportedEncodingException e3) {
                    throw new GenericFileOperationFailedException("Cannot store file: " + name, (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                IOHelper.close(is, (String)("store: " + name), (org.slf4j.Logger)LOG);
                throw throwable;
            }
        }
        IOHelper.close((Closeable)is, (String)("store: " + name), (org.slf4j.Logger)LOG);
        return bl;
    }

    public synchronized boolean existsFile(String name) throws GenericFileOperationFailedException {
        LOG.trace("existsFile({})", (Object)name);
        if (this.endpoint.isFastExistsCheck()) {
            return this.fastExistsFile(name);
        }
        String directory = FileUtil.onlyPath((String)name);
        if (directory == null) {
            directory = ".";
        }
        String onlyName = FileUtil.stripPath((String)name);
        try {
            Vector files = this.channel.ls(directory);
            if (files == null) {
                return false;
            }
            for (Object file : files) {
                ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)file;
                String existing = entry.getFilename();
                LOG.trace("Existing file: {}, target file: {}", (Object)existing, (Object)name);
                if ((existing = FileUtil.stripPath((String)existing)) == null || !existing.equals(onlyName)) continue;
                return true;
            }
            return false;
        }
        catch (SftpException e) {
            if (2 == e.id) {
                return false;
            }
            throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
        }
    }

    protected boolean fastExistsFile(String name) throws GenericFileOperationFailedException {
        LOG.trace("fastExistsFile({})", (Object)name);
        try {
            Vector files = this.channel.ls(name);
            if (files == null) {
                return false;
            }
            return files.size() >= 1;
        }
        catch (SftpException e) {
            if (2 == e.id) {
                return false;
            }
            throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public synchronized boolean sendNoop() throws GenericFileOperationFailedException {
        if (this.isConnected()) {
            try {
                this.session.sendKeepAliveMsg();
                return true;
            }
            catch (Exception e) {
                LOG.debug("SFTP session was closed. Ignoring this exception.", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    @Override
    public synchronized boolean sendSiteCommand(String command) throws GenericFileOperationFailedException {
        return true;
    }

    static Socket createSocketUtil(final String host, final int port, final String bindAddress, int timeout) {
        Socket socket = null;
        if (timeout == 0) {
            try {
                socket = new Socket(InetAddress.getByName(host), port, InetAddress.getByName(bindAddress), 0);
                return socket;
            }
            catch (Exception e) {
                String message = e.toString();
                throw new RuntimeCamelException(message, (Throwable)e);
            }
        }
        final Socket[] sockp = new Socket[1];
        final Exception[] ee = new Exception[1];
        Object message = "";
        Thread tmp = new Thread(new Runnable(){

            @Override
            public void run() {
                sockp[0] = null;
                try {
                    sockp[0] = new Socket(InetAddress.getByName(host), port, InetAddress.getByName(bindAddress), 0);
                }
                catch (Exception e) {
                    ee[0] = e;
                    if (sockp[0] != null && sockp[0].isConnected()) {
                        IOHelper.close((Closeable)sockp[0]);
                    }
                    sockp[0] = null;
                }
            }
        });
        tmp.setName("Opening Socket " + host);
        tmp.start();
        try {
            tmp.join(timeout);
            message = "timeout: ";
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (sockp[0] == null || !sockp[0].isConnected()) {
            message = (String)message + "socket is not established";
            if (ee[0] != null) {
                message = ee[0].toString();
            }
            tmp.interrupt();
            tmp = null;
            throw new RuntimeCamelException((String)message, (Throwable)ee[0]);
        }
        socket = sockp[0];
        return socket;
    }

    private void createResultHeadersFromExchange(SftpException sftpException, Exchange exchange) {
        if (sftpException == null) {
            exchange.getIn().setHeader("CamelFtpReplyCode", (Object)0);
            exchange.getIn().setHeader("CamelFtpReplyString", (Object)OK_MESSAGE);
        } else {
            exchange.getIn().setHeader("CamelFtpReplyCode", (Object)sftpException.id);
            exchange.getIn().setHeader("CamelFtpReplyString", (Object)sftpException.getMessage());
        }
    }

    private void chmodOfDirectory(String directory) {
        String chmodDirectory = this.endpoint.getConfiguration().getChmodDirectory();
        if (ObjectHelper.isNotEmpty((Object)chmodDirectory)) {
            LOG.trace("Setting permission: {} on directory: {}", (Object)chmodDirectory, (Object)directory);
            int permissions = Integer.parseInt(chmodDirectory, 8);
            try {
                this.channel.chmod(permissions, directory);
            }
            catch (SftpException e) {
                throw new GenericFileOperationFailedException("Cannot set permission on directory: " + directory, (Throwable)e);
            }
        }
    }

    private static final class JSchLogger
    implements Logger {
        private final LoggingLevel loggingLevel;

        private JSchLogger(LoggingLevel loggingLevel) {
            this.loggingLevel = loggingLevel;
        }

        public boolean isEnabled(int level) {
            switch (level) {
                case 4: {
                    return this.loggingLevel.isEnabled(LoggingLevel.ERROR) && LOG.isErrorEnabled();
                }
                case 3: {
                    return this.loggingLevel.isEnabled(LoggingLevel.ERROR) && LOG.isErrorEnabled();
                }
                case 2: {
                    return this.loggingLevel.isEnabled(LoggingLevel.WARN) && LOG.isWarnEnabled();
                }
                case 1: {
                    return this.loggingLevel.isEnabled(LoggingLevel.INFO) && LOG.isInfoEnabled();
                }
            }
            return this.loggingLevel.isEnabled(LoggingLevel.DEBUG) && LOG.isDebugEnabled();
        }

        public void log(int level, String message) {
            switch (level) {
                case 4: {
                    LOG.error("JSCH -> {}", (Object)message);
                    break;
                }
                case 3: {
                    LOG.error("JSCH -> {}", (Object)message);
                    break;
                }
                case 2: {
                    LOG.warn("JSCH -> {}", (Object)message);
                    break;
                }
                case 1: {
                    LOG.info("JSCH -> {}", (Object)message);
                    break;
                }
                default: {
                    LOG.debug("JSCH -> {}", (Object)message);
                }
            }
        }
    }

    public static interface ExtendedUserInfo
    extends UserInfo,
    UIKeyboardInteractive {
    }

    private static class TaskPayload {
        final RemoteFileConfiguration configuration;
        private Exception exception;

        public TaskPayload(RemoteFileConfiguration configuration) {
            this.configuration = configuration;
        }
    }
}

