/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.storage;

import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.CopyWriter;
import com.google.cloud.storage.Storage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.google.storage.GoogleCloudStorageConfiguration;
import org.apache.camel.component.google.storage.GoogleCloudStorageEndpoint;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.EmptyAsyncCallback;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleCloudStorageConsumer
extends ScheduledBatchPollingConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleCloudStorageConsumer.class);

    public GoogleCloudStorageConsumer(GoogleCloudStorageEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.getConfiguration().isMoveAfterRead()) {
            Bucket bucket = this.getStorageClient().get(this.getConfiguration().getDestinationBucket(), new Storage.BucketGetOption[0]);
            if (bucket != null) {
                LOG.trace("Bucket [{}] already exists", (Object)bucket.getName());
                return;
            }
            LOG.trace("Destination Bucket [{}] doesn't exist yet", (Object)this.getConfiguration().getDestinationBucket());
            if (this.getConfiguration().isAutoCreateBucket()) {
                GoogleCloudStorageEndpoint.createNewBucket(this.getConfiguration().getDestinationBucket(), this.getConfiguration(), this.getStorageClient());
            }
        }
    }

    protected int poll() throws Exception {
        Queue<Exchange> exchanges;
        this.shutdownRunningTask = null;
        this.pendingExchanges = 0;
        String fileName = this.getConfiguration().getObjectName();
        String bucketName = this.getConfiguration().getBucketName();
        if (fileName != null) {
            LOG.trace("Getting object in bucket [{}] with file name [{}]...", (Object)bucketName, (Object)fileName);
            Blob blob = this.getStorageClient().get(bucketName, fileName, new Storage.BlobGetOption[0]);
            exchanges = this.createExchanges(blob, fileName);
        } else {
            LOG.trace("Queueing objects in bucket [{}]...", (Object)bucketName);
            LinkedList<Blob> bloblist = new LinkedList<Blob>();
            for (Blob blob : this.getStorageClient().list(bucketName, new Storage.BlobListOption[0]).iterateAll()) {
                bloblist.add(blob);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Found {} objects in bucket [{}]...", (Object)bloblist.size(), (Object)bucketName);
            }
            exchanges = this.createExchanges(bloblist);
        }
        return this.processBatch(CastUtils.cast(exchanges));
    }

    protected Queue<Exchange> createExchanges(Blob blob, String key) {
        LinkedList<Exchange> answer = new LinkedList<Exchange>();
        Exchange exchange = this.createExchange(blob, key);
        answer.add(exchange);
        return answer;
    }

    protected Queue<Exchange> createExchanges(List<Blob> blobList) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Received {} messages in this poll", (Object)blobList.size());
        }
        LinkedList<Exchange> answer = new LinkedList<Exchange>();
        try {
            for (Blob blob : blobList) {
                if (!this.includeObject(blob)) continue;
                Exchange exchange = this.createExchange(blob, blob.getBlobId().getName());
                answer.add(exchange);
            }
        }
        catch (Exception e) {
            LOG.warn("Error getting object due: {}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
        return answer;
    }

    protected boolean includeObject(Blob blob) {
        if (this.getConfiguration().isIncludeFolders()) {
            return true;
        }
        return blob.getName().endsWith("/");
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            exchange.setProperty(ExchangePropertyKey.BATCH_INDEX, (Object)index);
            exchange.setProperty(ExchangePropertyKey.BATCH_SIZE, (Object)total);
            exchange.setProperty(ExchangePropertyKey.BATCH_COMPLETE, (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion(new Synchronization(){

                public void onComplete(Exchange exchange) {
                    GoogleCloudStorageConsumer.this.processCommit(exchange);
                }

                public void onFailure(Exchange exchange) {
                    GoogleCloudStorageConsumer.this.processRollback(exchange);
                }

                public String toString() {
                    return "ConsumerOnCompletion";
                }
            });
            this.defaultConsumerCallback(exchange, true);
            this.getAsyncProcessor().process(exchange, EmptyAsyncCallback.get());
        }
        return total;
    }

    protected void processCommit(Exchange exchange) {
        try {
            String key;
            String bucketName;
            if (this.getConfiguration().isMoveAfterRead()) {
                bucketName = (String)exchange.getIn().getHeader("CamelGoogleCloudStorageBucketName", String.class);
                key = (String)exchange.getIn().getHeader("CamelGoogleCloudStorageObjectName", String.class);
                LOG.trace("Moving object from bucket {} with key {} to bucket {}...", new Object[]{bucketName, key, this.getConfiguration().getDestinationBucket()});
                BlobId sourceBlobId = BlobId.of((String)bucketName, (String)key);
                BlobId targetBlobId = BlobId.of((String)this.getConfiguration().getDestinationBucket(), (String)key);
                Storage.CopyRequest request = Storage.CopyRequest.of((BlobId)sourceBlobId, (BlobId)targetBlobId);
                CopyWriter copyWriter = this.getStorageClient().copy(request);
                LOG.trace("Moved object from bucket {} with key {} to bucketName {} -> {}", new Object[]{bucketName, key, this.getConfiguration().getDestinationBucket(), copyWriter.getResult()});
            }
            if (this.getConfiguration().isDeleteAfterRead()) {
                bucketName = (String)exchange.getIn().getHeader("CamelGoogleCloudStorageBucketName", String.class);
                key = (String)exchange.getIn().getHeader("CamelGoogleCloudStorageObjectName", String.class);
                LOG.trace("Deleting object from bucket {} with key {}...", (Object)bucketName, (Object)key);
                boolean b = this.getStorageClient().delete(bucketName, key, new Storage.BlobSourceOption[0]);
                LOG.trace("Deleted object from bucket {} with key {}, result={}", new Object[]{bucketName, key, b});
            }
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException("Error occurred during moving or deleting object. This exception is ignored.", exchange, (Throwable)e);
        }
    }

    protected void processRollback(Exchange exchange) {
        Exception cause = exchange.getException();
        if (cause != null) {
            LOG.warn("Exchange failed, so rolling back message status: {}", (Object)exchange, (Object)cause);
        } else {
            LOG.warn("Exchange failed, so rolling back message status: {}", (Object)exchange);
        }
    }

    protected GoogleCloudStorageConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    protected Storage getStorageClient() {
        return this.getEndpoint().getStorageClient();
    }

    public GoogleCloudStorageEndpoint getEndpoint() {
        return (GoogleCloudStorageEndpoint)super.getEndpoint();
    }

    public Exchange createExchange(Blob blob, String key) {
        return this.createExchange(this.getEndpoint().getExchangePattern(), blob, key);
    }

    public Exchange createExchange(ExchangePattern pattern, Blob blob, String key) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Getting object with key [{}] from bucket [{}]...", (Object)key, (Object)this.getConfiguration().getBucketName());
            LOG.trace("Got object [{}]", (Object)blob);
        }
        Exchange exchange = this.createExchange(true);
        exchange.setPattern(pattern);
        Message message = exchange.getIn();
        if (this.getConfiguration().isIncludeBody()) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                blob.downloadTo((OutputStream)baos, new Blob.BlobSourceOption[0]);
                message.setBody((Object)baos.toByteArray());
            }
            catch (Exception e) {
                throw new RuntimeCamelException((Throwable)e);
            }
        } else {
            message.setBody((Object)blob);
        }
        message.setHeader("CamelGoogleCloudStorageObjectName", (Object)key);
        message.setHeader("CamelGoogleCloudStorageBucketName", (Object)this.getConfiguration().getBucketName());
        message.setHeader("CamelGoogleCloudStorageCacheControl", (Object)blob.getCacheControl());
        message.setHeader("CamelGoogleCloudStorageComponentCount", (Object)blob.getComponentCount());
        message.setHeader("CamelGoogleCloudStorageContentDisposition", (Object)blob.getContentDisposition());
        message.setHeader("CamelGoogleCloudStorageContentEncoding", (Object)blob.getContentEncoding());
        message.setHeader("CamelGoogleCloudStorageContentLanguage", (Object)blob.getContentLanguage());
        message.setHeader("CamelGoogleCloudStorageContentType", (Object)blob.getContentType());
        message.setHeader("CamelGoogleCloudStorageCustomTime", (Object)blob.getCustomTime());
        message.setHeader("CamelGoogleCloudStorageCrc32cHex", (Object)blob.getCrc32cToHexString());
        message.setHeader("CamelGoogleCloudStorageETag", (Object)blob.getEtag());
        message.setHeader("CamelGoogleCloudStorageGeneration", (Object)blob.getGeneration());
        message.setHeader("CamelGoogleCloudStorageBlobId", (Object)blob.getBlobId());
        message.setHeader("CamelGoogleCloudStorageKmsKeyName", (Object)blob.getKmsKeyName());
        message.setHeader("CamelGoogleCloudStorageContentMd5", (Object)blob.getMd5ToHexString());
        message.setHeader("CamelGoogleCloudStorageMediaLink", (Object)blob.getMediaLink());
        message.setHeader("CamelGoogleCloudStorageMetageneration", (Object)blob.getMetageneration());
        message.setHeader("CamelGoogleCloudStorageContentLength", (Object)blob.getSize());
        message.setHeader("CamelGoogleCloudStorageStorageClass", (Object)blob.getStorageClass());
        message.setHeader("CamelGoogleCloudStorageCreateTime", (Object)blob.getCreateTime());
        message.setHeader("CamelGoogleCloudStorageLastUpdate", (Object)new Date(blob.getUpdateTime()));
        return exchange;
    }
}

