/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.storage;

import com.google.api.client.util.Strings;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.component.google.storage.GoogleCloudStorageConfiguration;
import org.apache.camel.support.ResourceHelper;

public final class GoogleCloudStorageConnectionFactory {
    private GoogleCloudStorageConnectionFactory() {
    }

    public static Storage create(CamelContext context, GoogleCloudStorageConfiguration configuration) throws Exception {
        if (!Strings.isNullOrEmpty((String)configuration.getServiceAccountKey())) {
            InputStream resolveMandatoryResourceAsInputStream = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)context, (String)configuration.getServiceAccountKey());
            return (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)ServiceAccountCredentials.fromStream((InputStream)resolveMandatoryResourceAsInputStream))).build().getService();
        }
        return (Storage)StorageOptions.getDefaultInstance().getService();
    }
}

