/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http4;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.activation.FileTypeMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.StreamCache;
import org.apache.camel.component.http4.HttpBinding;
import org.apache.camel.component.http4.HttpConverter;
import org.apache.camel.component.http4.HttpEndpoint;
import org.apache.camel.component.http4.HttpHeaderFilterStrategy;
import org.apache.camel.component.http4.HttpMessage;
import org.apache.camel.component.http4.helper.GZIPHelper;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;

public class DefaultHttpBinding
implements HttpBinding {
    private boolean useReaderForPayload;
    private HeaderFilterStrategy headerFilterStrategy = new HttpHeaderFilterStrategy();

    public DefaultHttpBinding() {
    }

    public DefaultHttpBinding(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public void readRequest(HttpServletRequest request, HttpMessage message) {
        message.getBody();
        Map headers = message.getHeaders();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = request.getHeader(name);
            if (name.toLowerCase().equals("content-type")) {
                name = "Content-Type";
            }
            if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, (Object)value, message.getExchange())) continue;
            headers.put(name, value);
        }
        if (request.getCharacterEncoding() != null) {
            headers.put("CamelHttpCharacterEncoding", request.getCharacterEncoding());
            message.getExchange().setProperty("CamelCharsetName", (Object)request.getCharacterEncoding());
        }
        this.popluateRequestParameters(request, message);
        StreamCache cache = (StreamCache)message.getBody(StreamCache.class);
        if (cache != null) {
            cache.reset();
        }
        headers.put("CamelHttpMethod", request.getMethod());
        headers.put("CamelHttpQuery", request.getQueryString());
        headers.put("CamelHttpUrl", request.getRequestURL());
        headers.put("CamelHttpUri", request.getRequestURI());
        headers.put("CamelHttpPath", request.getPathInfo());
        headers.put("Content-Type", request.getContentType());
        this.popluateAttachments(request, message);
    }

    protected void popluateRequestParameters(HttpServletRequest request, HttpMessage message) {
        Map headers = message.getHeaders();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = request.getParameter(name);
            if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, (Object)value, message.getExchange())) continue;
            headers.put(name, value);
        }
        if (request.getMethod().equals("POST") && request.getContentType() != null && request.getContentType().equals("application/x-www-form-urlencoded")) {
            String charset = request.getCharacterEncoding();
            if (charset == null) {
                charset = "UTF-8";
            }
            String body = (String)message.getBody(String.class);
            try {
                for (String param : body.split("&")) {
                    String[] pair = param.split("=", 2);
                    String name = URLDecoder.decode(pair[0], charset);
                    String value = URLDecoder.decode(pair[1], charset);
                    if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, (Object)value, message.getExchange())) continue;
                    headers.put(name, value);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void popluateAttachments(HttpServletRequest request, HttpMessage message) {
        Enumeration names = request.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object object = request.getAttribute(name);
            if (!(object instanceof File)) continue;
            String fileName = request.getParameter(name);
            message.addAttachment(fileName, new DataHandler((Object)new FileDataSource((File)object), FileTypeMap.getDefaultFileTypeMap().getContentType(fileName)));
        }
    }

    public void writeResponse(Exchange exchange, HttpServletResponse response) throws IOException {
        if (exchange.isFailed()) {
            if (exchange.getException() != null) {
                this.doWriteExceptionResponse(exchange.getException(), response);
            } else {
                this.doWriteFaultResponse(exchange.getOut(), response, exchange);
            }
        } else {
            this.copyProtocolHeaders(exchange.getIn(), exchange.getOut());
            Message out = exchange.getOut();
            if (out != null) {
                this.doWriteResponse(out, response, exchange);
            }
        }
    }

    private void copyProtocolHeaders(Message request, Message response) {
        if (request.getHeader("Content-Encoding") != null) {
            String contentEncoding = (String)request.getHeader("Content-Encoding", String.class);
            response.setHeader("Content-Encoding", (Object)contentEncoding);
        }
        if (this.checkChunked(response, response.getExchange())) {
            response.setHeader("Transfer-Encoding", (Object)"chunked");
        }
    }

    public void doWriteExceptionResponse(Throwable exception, HttpServletResponse response) throws IOException {
        response.setStatus(500);
        response.setContentType("text/plain");
        PrintWriter pw = response.getWriter();
        exception.printStackTrace(pw);
        pw.flush();
    }

    public void doWriteFaultResponse(Message message, HttpServletResponse response, Exchange exchange) throws IOException {
        this.doWriteResponse(message, response, exchange);
    }

    public void doWriteResponse(Message message, HttpServletResponse response, Exchange exchange) throws IOException {
        if (message.getHeader("CamelHttpResponseCode") != null) {
            int code = (Integer)message.getHeader("CamelHttpResponseCode", Integer.class);
            response.setStatus(code);
        }
        String contentType = MessageHelper.getContentType((Message)message);
        if (MessageHelper.getContentType((Message)message) != null) {
            response.setContentType(contentType);
        }
        for (String key : message.getHeaders().keySet()) {
            String value = (String)message.getHeader(key, String.class);
            if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToCamelHeaders(key, (Object)value, exchange)) continue;
            response.setHeader(key, value);
        }
        if (message.getBody() != null) {
            if (GZIPHelper.isGzip(message)) {
                this.doWriteGZIPResponse(message, response, exchange);
            } else {
                this.doWriteDirectResponse(message, response, exchange);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWriteDirectResponse(Message message, HttpServletResponse response, Exchange exchange) throws IOException {
        InputStream is = null;
        if (this.checkChunked(message, exchange)) {
            is = (InputStream)message.getBody(InputStream.class);
        }
        if (is != null) {
            ServletOutputStream os = response.getOutputStream();
            try {
                IOHelper.copy((InputStream)is, (OutputStream)os);
            }
            finally {
                try {
                    os.close();
                }
                catch (Exception e) {}
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
        }
        String data = (String)message.getBody(String.class);
        if (data != null) {
            response.setContentLength(data.length());
            response.getWriter().print(data);
            response.getWriter().flush();
        }
    }

    protected boolean checkChunked(Message message, Exchange exchange) {
        boolean answer = true;
        if (message.getHeader("CamelHttpChunked") == null) {
            Endpoint endpoint = exchange.getFromEndpoint();
            if (endpoint instanceof HttpEndpoint) {
                answer = ((HttpEndpoint)endpoint).isChunked();
            }
        } else {
            answer = (Boolean)message.getHeader("CamelHttpChunked", Boolean.TYPE);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWriteGZIPResponse(Message message, HttpServletResponse response, Exchange exchange) throws IOException {
        byte[] bytes;
        try {
            bytes = (byte[])message.getMandatoryBody(byte[].class);
        }
        catch (InvalidPayloadException e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        byte[] data = GZIPHelper.compressGZIP(bytes);
        ServletOutputStream os = response.getOutputStream();
        try {
            response.setContentLength(data.length);
            os.write(data);
            os.flush();
        }
        finally {
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parseBody(HttpMessage httpMessage) throws IOException {
        HttpServletRequest request = httpMessage.getRequest();
        if ("GET".equals(request.getMethod())) {
            return null;
        }
        if (this.isUseReaderForPayload()) {
            return request.getReader();
        }
        InputStream is = HttpConverter.toInputStream(request, httpMessage.getExchange());
        if (is == null) {
            return is;
        }
        if (((Boolean)httpMessage.getExchange().getProperty("CamelDisableHttpStreamCache", (Object)Boolean.FALSE, Boolean.class)).booleanValue()) {
            return is;
        }
        try {
            CachedOutputStream cos = new CachedOutputStream(httpMessage.getExchange());
            IOHelper.copy((InputStream)is, (OutputStream)cos);
            StreamCache streamCache = cos.getStreamCache();
            return streamCache;
        }
        finally {
            is.close();
        }
    }

    public boolean isUseReaderForPayload() {
        return this.useReaderForPayload;
    }

    public void setUseReaderForPayload(boolean useReaderForPayload) {
        this.useReaderForPayload = useReaderForPayload;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }
}

