/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http4;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.component.http4.helper.GZIPHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.http.HttpEntity;
import org.apache.http.entity.InputStreamEntity;

@Converter
public class HttpEntityConverter {
    @Converter
    public HttpEntity toHttpEntity(byte[] data, Exchange exchange) throws Exception {
        return this.asHttpEntity(data, exchange);
    }

    @Converter
    public HttpEntity toHttpEntity(InputStream inStream, Exchange exchange) throws Exception {
        return this.asHttpEntity(inStream, exchange);
    }

    @Converter
    public HttpEntity toHttpEntity(String str, Exchange exchange) throws Exception {
        if (GZIPHelper.isGzip(exchange.getIn())) {
            byte[] data = (byte[])exchange.getContext().getTypeConverter().convertTo(byte[].class, (Object)str);
            return this.asHttpEntity(data, exchange);
        }
        return null;
    }

    private HttpEntity asHttpEntity(InputStream in, Exchange exchange) throws IOException {
        String contentEncoding = (String)exchange.getIn().getHeader("Content-Encoding", String.class);
        String contentType = ExchangeHelper.getContentType((Exchange)exchange);
        InputStreamEntity entity = null;
        entity = exchange == null || (Boolean)exchange.getProperty("CamelSkipGzipEncoding", (Object)Boolean.FALSE, Boolean.class) == false ? new InputStreamEntity(GZIPHelper.compressGzip(contentEncoding, in), -1L) : new InputStreamEntity(in, -1L);
        entity.setContentEncoding(contentEncoding);
        entity.setContentType(contentType);
        return entity;
    }

    private HttpEntity asHttpEntity(byte[] data, Exchange exchange) throws Exception {
        String contentEncoding = (String)exchange.getIn().getHeader("Content-Encoding", String.class);
        String contentType = ExchangeHelper.getContentType((Exchange)exchange);
        InputStreamEntity entity = null;
        entity = exchange == null || (Boolean)exchange.getProperty("CamelSkipGzipEncoding", (Object)Boolean.FALSE, Boolean.class) == false ? new InputStreamEntity(GZIPHelper.compressGzip(contentEncoding, data), -1L) : new InputStreamEntity((InputStream)new ByteArrayInputStream(data), -1L);
        entity.setContentEncoding(contentEncoding);
        entity.setContentType(contentType);
        return entity;
    }
}

