/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http4;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.http4.HttpEndpoint;
import org.apache.camel.component.http4.helper.LoadingByteArrayOutputStream;
import org.apache.camel.impl.PollingConsumerSupport;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class HttpPollingConsumer
extends PollingConsumerSupport {
    private final HttpEndpoint endpoint;
    private HttpClient httpClient;

    public HttpPollingConsumer(HttpEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.httpClient = endpoint.getHttpClient();
    }

    public Exchange receive() {
        return this.doReceive(-1);
    }

    public Exchange receive(long timeout) {
        return this.doReceive((int)timeout);
    }

    public Exchange receiveNoWait() {
        return this.doReceive(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Exchange doReceive(int timeout) {
        Exchange exchange = this.endpoint.createExchange();
        HttpRequestBase method = this.createMethod();
        if (timeout > 0) {
            HttpConnectionParams.setSoTimeout((HttpParams)method.getParams(), (int)timeout);
        }
        HttpEntity responeEntity = null;
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)method);
            int responseCode = response.getStatusLine().getStatusCode();
            responeEntity = response.getEntity();
            LoadingByteArrayOutputStream bos = new LoadingByteArrayOutputStream();
            InputStream is = responeEntity.getContent();
            try {
                IOHelper.copy((InputStream)is, (OutputStream)bos);
                bos.flush();
            }
            finally {
                ObjectHelper.close((Closeable)is, (String)"input stream", null);
            }
            Message message = exchange.getIn();
            message.setBody((Object)bos.createInputStream());
            Header[] headers = response.getAllHeaders();
            HeaderFilterStrategy strategy = this.endpoint.getHeaderFilterStrategy();
            for (Header header : headers) {
                String name = header.getName();
                String value = header.getValue();
                if (strategy == null || strategy.applyFilterToExternalHeaders(name, (Object)value, exchange)) continue;
                message.setHeader(name, (Object)value);
            }
            message.setHeader("CamelHttpResponseCode", (Object)responseCode);
            Exchange exchange2 = exchange;
            return exchange2;
        }
        catch (IOException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
        finally {
            if (responeEntity != null) {
                try {
                    responeEntity.consumeContent();
                }
                catch (IOException e) {}
            }
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    protected HttpRequestBase createMethod() {
        String uri = this.endpoint.getEndpointUri();
        return new HttpGet(uri);
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

